# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import outer_tag
from . import second_tag
class vlan_push(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-svc/supported-vlan-operations/vlan-push. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates VLAN push or swap operations capabilities.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_push_operation','__outer_tag','__second_tag',)

  _yang_name = 'vlan-push'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_push_operation = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="vlan-push-operation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    self.__outer_tag = YANGDynClass(base=outer_tag.outer_tag, is_container='container', yang_name="outer-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    self.__second_tag = YANGDynClass(base=second_tag.second_tag, is_container='container', yang_name="second-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-svc', 'supported-vlan-operations', 'vlan-push']

  def _get_vlan_push_operation(self):
    """
    Getter method for vlan_push_operation, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/vlan_push_operation (boolean)

    YANG Description: Indicates that the ETH LTP supports VLAN push or
swap operations.
    """
    return self.__vlan_push_operation
      
  def _set_vlan_push_operation(self, v, load=False):
    """
    Setter method for vlan_push_operation, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/vlan_push_operation (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_push_operation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_push_operation() directly.

    YANG Description: Indicates that the ETH LTP supports VLAN push or
swap operations.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="vlan-push-operation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_push_operation must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="vlan-push-operation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__vlan_push_operation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_push_operation(self):
    self.__vlan_push_operation = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="vlan-push-operation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)


  def _get_outer_tag(self):
    """
    Getter method for outer_tag, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/outer_tag (container)

    YANG Description: Indicates the supported VLAN operation capabilities
on the outer VLAN tag.
    """
    return self.__outer_tag
      
  def _set_outer_tag(self, v, load=False):
    """
    Setter method for outer_tag, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/outer_tag (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_tag is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_tag() directly.

    YANG Description: Indicates the supported VLAN operation capabilities
on the outer VLAN tag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=outer_tag.outer_tag, is_container='container', yang_name="outer-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_tag must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=outer_tag.outer_tag, is_container='container', yang_name="outer-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__outer_tag = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_tag(self):
    self.__outer_tag = YANGDynClass(base=outer_tag.outer_tag, is_container='container', yang_name="outer-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)


  def _get_second_tag(self):
    """
    Getter method for second_tag, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/second_tag (container)

    YANG Description: Indicates the supported VLAN operation capabilities
on the second VLAN tag.
    """
    return self.__second_tag
      
  def _set_second_tag(self, v, load=False):
    """
    Setter method for second_tag, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/second_tag (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_second_tag is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_second_tag() directly.

    YANG Description: Indicates the supported VLAN operation capabilities
on the second VLAN tag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=second_tag.second_tag, is_container='container', yang_name="second-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """second_tag must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=second_tag.second_tag, is_container='container', yang_name="second-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__second_tag = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_second_tag(self):
    self.__second_tag = YANGDynClass(base=second_tag.second_tag, is_container='container', yang_name="second-tag", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

  vlan_push_operation = __builtin__.property(_get_vlan_push_operation, _set_vlan_push_operation)
  outer_tag = __builtin__.property(_get_outer_tag, _set_outer_tag)
  second_tag = __builtin__.property(_get_second_tag, _set_second_tag)


  _pyangbind_elements = OrderedDict([('vlan_push_operation', vlan_push_operation), ('outer_tag', outer_tag), ('second_tag', second_tag), ])


