# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_topology_validation_mechanism import TapiTopologyValidationMechanism  # noqa: F401,E501
from tapi_server import util


class TapiTopologyValidationPac(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, validation_mechanism: List[TapiTopologyValidationMechanism]=None):  # noqa: E501
        """TapiTopologyValidationPac - a model defined in Swagger

        :param validation_mechanism: The validation_mechanism of this TapiTopologyValidationPac.  # noqa: E501
        :type validation_mechanism: List[TapiTopologyValidationMechanism]
        """
        self.swagger_types = {
            'validation_mechanism': List[TapiTopologyValidationMechanism]
        }

        self.attribute_map = {
            'validation_mechanism': 'validation-mechanism'
        }
        self._validation_mechanism = validation_mechanism

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyValidationPac':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.ValidationPac of this TapiTopologyValidationPac.  # noqa: E501
        :rtype: TapiTopologyValidationPac
        """
        return util.deserialize_model(dikt, cls)

    @property
    def validation_mechanism(self) -> List[TapiTopologyValidationMechanism]:
        """Gets the validation_mechanism of this TapiTopologyValidationPac.

        Provides details of the specific validation mechanism(s) used to confirm the presence of an intended topologicalEntity.  # noqa: E501

        :return: The validation_mechanism of this TapiTopologyValidationPac.
        :rtype: List[TapiTopologyValidationMechanism]
        """
        return self._validation_mechanism

    @validation_mechanism.setter
    def validation_mechanism(self, validation_mechanism: List[TapiTopologyValidationMechanism]):
        """Sets the validation_mechanism of this TapiTopologyValidationPac.

        Provides details of the specific validation mechanism(s) used to confirm the presence of an intended topologicalEntity.  # noqa: E501

        :param validation_mechanism: The validation_mechanism of this TapiTopologyValidationPac.
        :type validation_mechanism: List[TapiTopologyValidationMechanism]
        """

        self._validation_mechanism = validation_mechanism
