# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_capacity import TapiCommonCapacity  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_port_direction import TapiCommonPortDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_port_role import TapiCommonPortRole  # noqa: F401,E501
from tapi_server.models.tapi_common_service_interface_point_ref import TapiCommonServiceInterfacePointRef  # noqa: F401,E501
from tapi_server.models.tapi_common_termination_direction import TapiCommonTerminationDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_termination_state import TapiCommonTerminationState  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_cep_list import TapiConnectivityCepList  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_owned_node_edge_point_augmentation1 import TapiConnectivityOwnedNodeEdgePointAugmentation1  # noqa: F401,E501
from tapi_server.models.tapi_topology_node_edge_point import TapiTopologyNodeEdgePoint  # noqa: F401,E501
from tapi_server.models.tapi_topology_node_edge_point_ref import TapiTopologyNodeEdgePointRef  # noqa: F401,E501
from tapi_server import util


class TapiTopologyNodeOwnedNodeEdgePoint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, available_capacity: TapiCommonCapacity=None, total_potential_capacity: TapiCommonCapacity=None, name: List[TapiCommonNameAndValue]=None, uuid: str=None, termination_direction: TapiCommonTerminationDirection=None, termination_state: TapiCommonTerminationState=None, link_port_role: TapiCommonPortRole=None, mapped_service_interface_point: List[TapiCommonServiceInterfacePointRef]=None, aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]=None, layer_protocol_name: TapiCommonLayerProtocolName=None, link_port_direction: TapiCommonPortDirection=None, supported_cep_layer_protocol_qualifier: List[str]=None, cep_list: TapiConnectivityCepList=None):  # noqa: E501
        """TapiTopologyNodeOwnedNodeEdgePoint - a model defined in Swagger

        :param available_capacity: The available_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type available_capacity: TapiCommonCapacity
        :param total_potential_capacity: The total_potential_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type total_potential_capacity: TapiCommonCapacity
        :param name: The name of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type uuid: str
        :param termination_direction: The termination_direction of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type termination_direction: TapiCommonTerminationDirection
        :param termination_state: The termination_state of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type termination_state: TapiCommonTerminationState
        :param link_port_role: The link_port_role of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type link_port_role: TapiCommonPortRole
        :param mapped_service_interface_point: The mapped_service_interface_point of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type mapped_service_interface_point: List[TapiCommonServiceInterfacePointRef]
        :param aggregated_node_edge_point: The aggregated_node_edge_point of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]
        :param layer_protocol_name: The layer_protocol_name of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type layer_protocol_name: TapiCommonLayerProtocolName
        :param link_port_direction: The link_port_direction of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type link_port_direction: TapiCommonPortDirection
        :param supported_cep_layer_protocol_qualifier: The supported_cep_layer_protocol_qualifier of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type supported_cep_layer_protocol_qualifier: List[str]
        :param cep_list: The cep_list of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :type cep_list: TapiConnectivityCepList
        """
        self.swagger_types = {
            'available_capacity': TapiCommonCapacity,
            'total_potential_capacity': TapiCommonCapacity,
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'termination_direction': TapiCommonTerminationDirection,
            'termination_state': TapiCommonTerminationState,
            'link_port_role': TapiCommonPortRole,
            'mapped_service_interface_point': List[TapiCommonServiceInterfacePointRef],
            'aggregated_node_edge_point': List[TapiTopologyNodeEdgePointRef],
            'layer_protocol_name': TapiCommonLayerProtocolName,
            'link_port_direction': TapiCommonPortDirection,
            'supported_cep_layer_protocol_qualifier': List[str],
            'cep_list': TapiConnectivityCepList
        }

        self.attribute_map = {
            'available_capacity': 'available-capacity',
            'total_potential_capacity': 'total-potential-capacity',
            'name': 'name',
            'uuid': 'uuid',
            'termination_direction': 'termination-direction',
            'termination_state': 'termination-state',
            'link_port_role': 'link-port-role',
            'mapped_service_interface_point': 'mapped-service-interface-point',
            'aggregated_node_edge_point': 'aggregated-node-edge-point',
            'layer_protocol_name': 'layer-protocol-name',
            'link_port_direction': 'link-port-direction',
            'supported_cep_layer_protocol_qualifier': 'supported-cep-layer-protocol-qualifier',
            'cep_list': 'cep-list'
        }
        self._available_capacity = available_capacity
        self._total_potential_capacity = total_potential_capacity
        self._name = name
        self._uuid = uuid
        self._termination_direction = termination_direction
        self._termination_state = termination_state
        self._link_port_role = link_port_role
        self._mapped_service_interface_point = mapped_service_interface_point
        self._aggregated_node_edge_point = aggregated_node_edge_point
        self._layer_protocol_name = layer_protocol_name
        self._link_port_direction = link_port_direction
        self._supported_cep_layer_protocol_qualifier = supported_cep_layer_protocol_qualifier
        self._cep_list = cep_list

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyNodeOwnedNodeEdgePoint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.node.OwnedNodeEdgePoint of this TapiTopologyNodeOwnedNodeEdgePoint.  # noqa: E501
        :rtype: TapiTopologyNodeOwnedNodeEdgePoint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def available_capacity(self) -> TapiCommonCapacity:
        """Gets the available_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The available_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonCapacity
        """
        return self._available_capacity

    @available_capacity.setter
    def available_capacity(self, available_capacity: TapiCommonCapacity):
        """Sets the available_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param available_capacity: The available_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type available_capacity: TapiCommonCapacity
        """

        self._available_capacity = available_capacity

    @property
    def total_potential_capacity(self) -> TapiCommonCapacity:
        """Gets the total_potential_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The total_potential_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonCapacity
        """
        return self._total_potential_capacity

    @total_potential_capacity.setter
    def total_potential_capacity(self, total_potential_capacity: TapiCommonCapacity):
        """Sets the total_potential_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param total_potential_capacity: The total_potential_capacity of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type total_potential_capacity: TapiCommonCapacity
        """

        self._total_potential_capacity = total_potential_capacity

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiTopologyNodeOwnedNodeEdgePoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiTopologyNodeOwnedNodeEdgePoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiTopologyNodeOwnedNodeEdgePoint.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiTopologyNodeOwnedNodeEdgePoint.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def termination_direction(self) -> TapiCommonTerminationDirection:
        """Gets the termination_direction of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The termination_direction of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonTerminationDirection
        """
        return self._termination_direction

    @termination_direction.setter
    def termination_direction(self, termination_direction: TapiCommonTerminationDirection):
        """Sets the termination_direction of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param termination_direction: The termination_direction of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type termination_direction: TapiCommonTerminationDirection
        """

        self._termination_direction = termination_direction

    @property
    def termination_state(self) -> TapiCommonTerminationState:
        """Gets the termination_state of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The termination_state of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonTerminationState
        """
        return self._termination_state

    @termination_state.setter
    def termination_state(self, termination_state: TapiCommonTerminationState):
        """Sets the termination_state of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param termination_state: The termination_state of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type termination_state: TapiCommonTerminationState
        """

        self._termination_state = termination_state

    @property
    def link_port_role(self) -> TapiCommonPortRole:
        """Gets the link_port_role of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The link_port_role of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonPortRole
        """
        return self._link_port_role

    @link_port_role.setter
    def link_port_role(self, link_port_role: TapiCommonPortRole):
        """Sets the link_port_role of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param link_port_role: The link_port_role of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type link_port_role: TapiCommonPortRole
        """

        self._link_port_role = link_port_role

    @property
    def mapped_service_interface_point(self) -> List[TapiCommonServiceInterfacePointRef]:
        """Gets the mapped_service_interface_point of this TapiTopologyNodeOwnedNodeEdgePoint.

        NodeEdgePoint mapped to more than ServiceInterfacePoint (slicing/virtualizing) or a ServiceInterfacePoint mapped to more than one NodeEdgePoint (load balancing/Resilience) should be considered experimental  # noqa: E501

        :return: The mapped_service_interface_point of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: List[TapiCommonServiceInterfacePointRef]
        """
        return self._mapped_service_interface_point

    @mapped_service_interface_point.setter
    def mapped_service_interface_point(self, mapped_service_interface_point: List[TapiCommonServiceInterfacePointRef]):
        """Sets the mapped_service_interface_point of this TapiTopologyNodeOwnedNodeEdgePoint.

        NodeEdgePoint mapped to more than ServiceInterfacePoint (slicing/virtualizing) or a ServiceInterfacePoint mapped to more than one NodeEdgePoint (load balancing/Resilience) should be considered experimental  # noqa: E501

        :param mapped_service_interface_point: The mapped_service_interface_point of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type mapped_service_interface_point: List[TapiCommonServiceInterfacePointRef]
        """

        self._mapped_service_interface_point = mapped_service_interface_point

    @property
    def aggregated_node_edge_point(self) -> List[TapiTopologyNodeEdgePointRef]:
        """Gets the aggregated_node_edge_point of this TapiTopologyNodeOwnedNodeEdgePoint.

        none  # noqa: E501

        :return: The aggregated_node_edge_point of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: List[TapiTopologyNodeEdgePointRef]
        """
        return self._aggregated_node_edge_point

    @aggregated_node_edge_point.setter
    def aggregated_node_edge_point(self, aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]):
        """Sets the aggregated_node_edge_point of this TapiTopologyNodeOwnedNodeEdgePoint.

        none  # noqa: E501

        :param aggregated_node_edge_point: The aggregated_node_edge_point of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]
        """

        self._aggregated_node_edge_point = aggregated_node_edge_point

    @property
    def layer_protocol_name(self) -> TapiCommonLayerProtocolName:
        """Gets the layer_protocol_name of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The layer_protocol_name of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TapiCommonLayerProtocolName):
        """Sets the layer_protocol_name of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param layer_protocol_name: The layer_protocol_name of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type layer_protocol_name: TapiCommonLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def link_port_direction(self) -> TapiCommonPortDirection:
        """Gets the link_port_direction of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The link_port_direction of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiCommonPortDirection
        """
        return self._link_port_direction

    @link_port_direction.setter
    def link_port_direction(self, link_port_direction: TapiCommonPortDirection):
        """Sets the link_port_direction of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param link_port_direction: The link_port_direction of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type link_port_direction: TapiCommonPortDirection
        """

        self._link_port_direction = link_port_direction

    @property
    def supported_cep_layer_protocol_qualifier(self) -> List[str]:
        """Gets the supported_cep_layer_protocol_qualifier of this TapiTopologyNodeOwnedNodeEdgePoint.

        none  # noqa: E501

        :return: The supported_cep_layer_protocol_qualifier of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: List[str]
        """
        return self._supported_cep_layer_protocol_qualifier

    @supported_cep_layer_protocol_qualifier.setter
    def supported_cep_layer_protocol_qualifier(self, supported_cep_layer_protocol_qualifier: List[str]):
        """Sets the supported_cep_layer_protocol_qualifier of this TapiTopologyNodeOwnedNodeEdgePoint.

        none  # noqa: E501

        :param supported_cep_layer_protocol_qualifier: The supported_cep_layer_protocol_qualifier of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type supported_cep_layer_protocol_qualifier: List[str]
        """

        self._supported_cep_layer_protocol_qualifier = supported_cep_layer_protocol_qualifier

    @property
    def cep_list(self) -> TapiConnectivityCepList:
        """Gets the cep_list of this TapiTopologyNodeOwnedNodeEdgePoint.


        :return: The cep_list of this TapiTopologyNodeOwnedNodeEdgePoint.
        :rtype: TapiConnectivityCepList
        """
        return self._cep_list

    @cep_list.setter
    def cep_list(self, cep_list: TapiConnectivityCepList):
        """Sets the cep_list of this TapiTopologyNodeOwnedNodeEdgePoint.


        :param cep_list: The cep_list of this TapiTopologyNodeOwnedNodeEdgePoint.
        :type cep_list: TapiConnectivityCepList
        """

        self._cep_list = cep_list
