# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_notification_notification import TapiNotificationNotification  # noqa: F401,E501
from tapi_server.models.tapi_notification_notification_channel import TapiNotificationNotificationChannel  # noqa: F401,E501
from tapi_server.models.tapi_notification_notification_type import TapiNotificationNotificationType  # noqa: F401,E501
from tapi_server.models.tapi_notification_object_type import TapiNotificationObjectType  # noqa: F401,E501
from tapi_server.models.tapi_notification_subscription_filter import TapiNotificationSubscriptionFilter  # noqa: F401,E501
from tapi_server.models.tapi_notification_subscription_state import TapiNotificationSubscriptionState  # noqa: F401,E501
from tapi_server import util


class TapiNotificationNotificationSubscriptionService(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, uuid: str=None, notification: List[TapiNotificationNotification]=None, notification_channel: TapiNotificationNotificationChannel=None, subscription_state: TapiNotificationSubscriptionState=None, supported_object_types: List[TapiNotificationObjectType]=None, supported_notification_types: List[TapiNotificationNotificationType]=None, subscription_filter: TapiNotificationSubscriptionFilter=None):  # noqa: E501
        """TapiNotificationNotificationSubscriptionService - a model defined in Swagger

        :param name: The name of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type uuid: str
        :param notification: The notification of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type notification: List[TapiNotificationNotification]
        :param notification_channel: The notification_channel of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type notification_channel: TapiNotificationNotificationChannel
        :param subscription_state: The subscription_state of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type subscription_state: TapiNotificationSubscriptionState
        :param supported_object_types: The supported_object_types of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type supported_object_types: List[TapiNotificationObjectType]
        :param supported_notification_types: The supported_notification_types of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type supported_notification_types: List[TapiNotificationNotificationType]
        :param subscription_filter: The subscription_filter of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :type subscription_filter: TapiNotificationSubscriptionFilter
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'notification': List[TapiNotificationNotification],
            'notification_channel': TapiNotificationNotificationChannel,
            'subscription_state': TapiNotificationSubscriptionState,
            'supported_object_types': List[TapiNotificationObjectType],
            'supported_notification_types': List[TapiNotificationNotificationType],
            'subscription_filter': TapiNotificationSubscriptionFilter
        }

        self.attribute_map = {
            'name': 'name',
            'uuid': 'uuid',
            'notification': 'notification',
            'notification_channel': 'notification-channel',
            'subscription_state': 'subscription-state',
            'supported_object_types': 'supported-object-types',
            'supported_notification_types': 'supported-notification-types',
            'subscription_filter': 'subscription-filter'
        }
        self._name = name
        self._uuid = uuid
        self._notification = notification
        self._notification_channel = notification_channel
        self._subscription_state = subscription_state
        self._supported_object_types = supported_object_types
        self._supported_notification_types = supported_notification_types
        self._subscription_filter = subscription_filter

    @classmethod
    def from_dict(cls, dikt) -> 'TapiNotificationNotificationSubscriptionService':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.notification.NotificationSubscriptionService of this TapiNotificationNotificationSubscriptionService.  # noqa: E501
        :rtype: TapiNotificationNotificationSubscriptionService
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiNotificationNotificationSubscriptionService.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiNotificationNotificationSubscriptionService.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiNotificationNotificationSubscriptionService.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiNotificationNotificationSubscriptionService.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiNotificationNotificationSubscriptionService.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiNotificationNotificationSubscriptionService.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiNotificationNotificationSubscriptionService.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiNotificationNotificationSubscriptionService.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def notification(self) -> List[TapiNotificationNotification]:
        """Gets the notification of this TapiNotificationNotificationSubscriptionService.

        none  # noqa: E501

        :return: The notification of this TapiNotificationNotificationSubscriptionService.
        :rtype: List[TapiNotificationNotification]
        """
        return self._notification

    @notification.setter
    def notification(self, notification: List[TapiNotificationNotification]):
        """Sets the notification of this TapiNotificationNotificationSubscriptionService.

        none  # noqa: E501

        :param notification: The notification of this TapiNotificationNotificationSubscriptionService.
        :type notification: List[TapiNotificationNotification]
        """

        self._notification = notification

    @property
    def notification_channel(self) -> TapiNotificationNotificationChannel:
        """Gets the notification_channel of this TapiNotificationNotificationSubscriptionService.


        :return: The notification_channel of this TapiNotificationNotificationSubscriptionService.
        :rtype: TapiNotificationNotificationChannel
        """
        return self._notification_channel

    @notification_channel.setter
    def notification_channel(self, notification_channel: TapiNotificationNotificationChannel):
        """Sets the notification_channel of this TapiNotificationNotificationSubscriptionService.


        :param notification_channel: The notification_channel of this TapiNotificationNotificationSubscriptionService.
        :type notification_channel: TapiNotificationNotificationChannel
        """

        self._notification_channel = notification_channel

    @property
    def subscription_state(self) -> TapiNotificationSubscriptionState:
        """Gets the subscription_state of this TapiNotificationNotificationSubscriptionService.


        :return: The subscription_state of this TapiNotificationNotificationSubscriptionService.
        :rtype: TapiNotificationSubscriptionState
        """
        return self._subscription_state

    @subscription_state.setter
    def subscription_state(self, subscription_state: TapiNotificationSubscriptionState):
        """Sets the subscription_state of this TapiNotificationNotificationSubscriptionService.


        :param subscription_state: The subscription_state of this TapiNotificationNotificationSubscriptionService.
        :type subscription_state: TapiNotificationSubscriptionState
        """

        self._subscription_state = subscription_state

    @property
    def supported_object_types(self) -> List[TapiNotificationObjectType]:
        """Gets the supported_object_types of this TapiNotificationNotificationSubscriptionService.

        none  # noqa: E501

        :return: The supported_object_types of this TapiNotificationNotificationSubscriptionService.
        :rtype: List[TapiNotificationObjectType]
        """
        return self._supported_object_types

    @supported_object_types.setter
    def supported_object_types(self, supported_object_types: List[TapiNotificationObjectType]):
        """Sets the supported_object_types of this TapiNotificationNotificationSubscriptionService.

        none  # noqa: E501

        :param supported_object_types: The supported_object_types of this TapiNotificationNotificationSubscriptionService.
        :type supported_object_types: List[TapiNotificationObjectType]
        """

        self._supported_object_types = supported_object_types

    @property
    def supported_notification_types(self) -> List[TapiNotificationNotificationType]:
        """Gets the supported_notification_types of this TapiNotificationNotificationSubscriptionService.

        none  # noqa: E501

        :return: The supported_notification_types of this TapiNotificationNotificationSubscriptionService.
        :rtype: List[TapiNotificationNotificationType]
        """
        return self._supported_notification_types

    @supported_notification_types.setter
    def supported_notification_types(self, supported_notification_types: List[TapiNotificationNotificationType]):
        """Sets the supported_notification_types of this TapiNotificationNotificationSubscriptionService.

        none  # noqa: E501

        :param supported_notification_types: The supported_notification_types of this TapiNotificationNotificationSubscriptionService.
        :type supported_notification_types: List[TapiNotificationNotificationType]
        """

        self._supported_notification_types = supported_notification_types

    @property
    def subscription_filter(self) -> TapiNotificationSubscriptionFilter:
        """Gets the subscription_filter of this TapiNotificationNotificationSubscriptionService.


        :return: The subscription_filter of this TapiNotificationNotificationSubscriptionService.
        :rtype: TapiNotificationSubscriptionFilter
        """
        return self._subscription_filter

    @subscription_filter.setter
    def subscription_filter(self, subscription_filter: TapiNotificationSubscriptionFilter):
        """Sets the subscription_filter of this TapiNotificationNotificationSubscriptionService.


        :param subscription_filter: The subscription_filter of this TapiNotificationNotificationSubscriptionService.
        :type subscription_filter: TapiNotificationSubscriptionFilter
        """

        self._subscription_filter = subscription_filter
