    def retrieve_external_topologies(self):
        i = 1
        while True:
            try:
                ADD  = str(get_setting(f'EXT_CONTROLLER{i}_ADD'))
                PORT = int(get_setting(f'EXT_CONTROLLER{i}_PORT'))
            except: # pylint: disable=bare-except
                break

            try:
                LOGGER.info('Retrieving external controller #{:d}'.format(i))
                url = 'http://{:s}:{:d}/tfs-api/context/{:s}/topology_details/{:s}'.format(
                    ADD, PORT, DEFAULT_CONTEXT_NAME, DEFAULT_TOPOLOGY_NAME
                )
                LOGGER.info('url={:s}'.format(str(url)))
                topo = requests.get(url).json()
                LOGGER.info('Retrieved external controller #{:d}'.format(i))
            except: # pylint: disable=bare-except
                LOGGER.exception('Exception retrieven topology from external controler #{:d}'.format(i))

            topology_details = TopologyDetails(**topo)
            context = Context()
            context.context_id.context_uuid.uuid = topology_details.topology_id.context_id.context_uuid.uuid
            context_client.SetContext(context)

            topology = Topology()
            topology.topology_id.context_id.CopyFrom(context.context_id)
            topology.topology_id.topology_uuid.uuid = topology_details.topology_id.topology_uuid.uuid
            context_client.SetTopology(topology)

            for device in topology_details.devices:
                context_client.SetDevice(device)

            for link in topology_details.links:
                context_client.SetLink(link)

            i+=1
