# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from typing import Dict, List, Optional
from common.proto.policy_condition_pb2 import BooleanOperator

LOGGER = logging.getLogger(__name__)

def json_policy_rule_id(policy_rule_uuid : str) -> Dict:
    return {'uuid': {'uuid': policy_rule_uuid}}

def json_policy_rule(
    policy_rule_uuid : str, policy_priority : int = 1,
    boolean_operator : BooleanOperator = BooleanOperator.POLICYRULE_CONDITION_BOOLEAN_AND,
    condition_list : List[Dict] = [], action_list : List[Dict] = [],
    service_id : Optional[Dict] = None, device_id_list : List[Dict] = []
) -> Dict:
    basic = {
        'policyRuleId': json_policy_rule_id(policy_rule_uuid),
        'priority': policy_priority,
        'conditionList': condition_list,
        'booleanOperator': boolean_operator,
        'actionList': action_list,
    }

    result = {}
    if service_id is not None:
        policy_rule_type = 'service'
        result[policy_rule_type] = {'policyRuleBasic': basic}
        result[policy_rule_type]['serviceId'] = service_id
    else:
        policy_rule_type = 'device'
        result[policy_rule_type] = {'policyRuleBasic': basic}

    result[policy_rule_type]['deviceList'] = device_id_list
    return result
