import os,grpc

from interdomain.proto import interdomain_pb2
from interdomain.proto import interdomain_pb2_grpc

from common.rpc_method_wrapper.ServiceExceptions import ServiceException
from common.logger import getJSONLogger

from context.proto import context_pb2

from slice.Config import GRPC_SERVICE_PORT
from slice.client.SliceClient import SliceClient
from slice.proto import slice_pb2

LOGGER = getJSONLogger('interdomainservice-server')
LOGGER.setLevel('DEBUG')

class InterdomainServiceServicerImpl(interdomain_pb2_grpc.InterdomainServiceServicer):
    def __init__(self):
        LOGGER.info('Init InterdomainService')

    # rpc Authenticate (context.TeraFlowController) returns (context.AuthenticationResult) {}
    def Authenticate(self, request : context_pb2.TeraFlowController) -> context_pb2.AuthenticationResult :
        LOGGER.info('Authenticate')
        auth_result = context_pb2.AuthenticationResult()
        auth_result.context_id = 0
        auth_result.authenticated = True
        return auth_result

    # rpc LookUpSlice(slice.TransportSlice) returns (slice.SliceId) {}
    def LookUpSlice ( self, request : slice_pb2.TransportSlice) -> slice_pb2.SliceId:

        LOGGER.info('LookUpSlice')
        try:
            slice_id = slice_pb2.SliceId()

            return sliceId
        except Exception as e:  
            LOGGER.exception('LookUpSlice exception')



    # rpc OrderSliceFromCatalog(slice.TransportSlice) returns (slice.SliceStatus) {}
    def OrderSliceFromCatalog(self, request : slice_pb2.TransportSlice) -> slice_pb2.SliceStatus:

        LOGGER.info('OrderSliceFromCatalog')

        try:
            slice_status=slice_pb2.SliceStatus()
            return slice_status
        except Exception as e:  # pragma: no cover
            LOGGER.exception('OrderSliceFromCatalog exception')


    # rpc CreateSliceAndAddToCatalog(slice.TransportSlice) returns (slice.SliceStatus) {}
    def CreateSliceAndAddToCatalog(self, request : slice_pb2.TransportSlice) -> slice_pb2.SliceStatus:

        LOGGER.info('OrderSliceFromCatalog')

        try:
            slice_status=slice_pb2.SliceStatus()
            return slice_status
        except Exception as e:  # pragma: no cover
            LOGGER.exception('OrderSliceFromCatalog exception')


