# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

def compose_topology_id(context_uuid, topology_uuid) -> Dict:
    return {'contextId': context_uuid, 'topology_uuid': topology_uuid}

def compose_endpoint_id(topology_id : Dict, device_uuid, endpoint_uuid) -> Dict:
    return {'topology_id': topology_id, 'device_id': device_uuid, 'endpoint_uuid': endpoint_uuid}

def compose_capacity(value, unit) -> Dict:
    return {'total-size': 'value': value, 'unit': unit}

def compose_endpoint(
    endpoint_id : Dict, endpoint_type : str, link_port_direction : int, termination_direction : int,
    termination_state : int, total_potential_capacity : Dict, available_capacity : Dict
) -> Dict:
    return {
        'endpoint_id': endpoint_id, 'endpoint_type': endpoint_type, 'link_port_direction': link_port_direction,
        'termination-direction': termination_direction, 'termination-state': termination_state,
        'total-potential-capacity': total_potential_capacity, 'available-capacity': available_capacity,
    }

def compose_device(grpc_device : Device) -> Dict:
    device_uuid = grpc_device.device_id.device_uuid.uuid
    device_type = grpc_device.device_type

    endpoints = []
    for device_endpoint in grpc_device.device_endpoints:
        topology_id = compose_topology_id(endpoint_context_uuid, endpoint_topology_uuid)
        endpoint_id = compose_endpoint_id(topology_id, device_uuid, endpoint_uuid)
        endpoint_type = 'termination'
        link_port_direction = 0
        termination_direction = 0
        termination_state = 0 or 4
        total_potential_capacity = compose_capacity(200, 5)
        available_capacity = compose_capacity(200, 5)
        endpoint = compose_endpoint(
            endpoint_id, endpoint_type, link_port_direction, termination_direction,
            termination_state, total_potential_capacity, available_capacity)
        endpoints.append(endpoint)

    return {'device_Id': device_uuid, 'device_type': device_type, 'device_endpoints': endpoints}