from typing import Any
from common.type_checkers.Checkers import chk_not_none
from .StringField import StringField

class PrimaryKeyField(StringField):
    def __init__(self, *args, required : bool = True, **kwargs) -> None:
        super().__init__(*args, required=True, allow_empty=False, min_length=1, **kwargs)

    def __set__(self, instance, value : str):
        chk_not_none(self.name, value) # Always required
        if (self.name in instance.__dict__) and (instance.__dict__[self.name] is not None):
            raise ValueError('PrimaryKeyField cannot be modified')
        return super().__set__(instance, value)
