from typing import Optional
from common.type_checkers.Checkers import chk_integer, chk_not_none
from .Field import Field

class IntegerField(Field):
    def __init__(
        self, *args, min_value : Optional[int] = None, max_value : Optional[int] = None, **kwargs) -> None:

        super().__init__(*args, type_=int, **kwargs)
        self._min_value = None if min_value is None else \
            chk_integer('{}.min_value'.format(self.name), min_value)
        self._max_value = None if max_value is None else \
            chk_integer('{}.max_value'.format(self.name), max_value, min_value=self._min_value)

    def __set__(self, instance, value : int) -> None:
        if self.required: chk_not_none(self.name, value)
        if value is None: super().__set__(instance, value)
        super().__set__(instance, chk_integer(self.name, value, min_value=self._min_value, max_value=self._max_value))
