from typing import Optional
from .Field import Field

class ForeignKeyField(Field):
    def __init__(self, *args, foreign_model : 'Model' = None, **kwargs) -> None:
        self.foreign_model = foreign_model
        super().__init__(*args, type_=(float, int), **kwargs)

    def __set__(self, instance, value):
        if self.min_value is not None and value < self.min_value:
            raise ValueError('Attribute "{:s}" expects value >= {:s}; requested({:s})'.format(
                str(self.name), str(self.min_value), str(value)))
        if self.max_value is not None and value > self.max_value:
            raise ValueError('Attribute "{:s}" expects value <= {:s}; requested({:s})'.format(
                str(self.name), str(self.max_value), str(value)))
        super().__set__(instance, value)
