from typing import Optional
from common.type_checkers.Checkers import chk_float, chk_not_none
from .Field import Field

class FloatField(Field):
    def __init__(
        self, *args, min_value : Optional[float] = None, max_value : Optional[float] = None, **kwargs) -> None:

        super().__init__(*args, type_=(float, int), **kwargs)
        self._min_value = None if min_value is None else \
            chk_float('{}.min_value'.format(self.name), min_value)
        self._max_value = None if max_value is None else \
            chk_float('{}.max_value'.format(self.name), max_value, min_value=self._min_value)

    def __set__(self, instance, value : float) -> None:
        if self.required: chk_not_none(self.name, value)
        if value is None: super().__set__(instance, value)
        super().__set__(instance, chk_float(self.name, value, min_value=self._min_value, max_value=self._max_value))
