from typing import Any, List, Set, Tuple, Union
from common.type_checkers.Checkers import chk_boolean, chk_string, chk_type

class Field:
    def __init__(
        self, name : str = None, type_ : Union[type, Set[type], Tuple[type], List[type]] = object,
        required : bool = False) -> None:
        self.name = None if name is None else chk_string('Field.name', name)
        self.type_ = chk_type('Field.type', type_, (type, set, tuple, list))
        self.required = chk_boolean('Field.required', required)

    def __set__(self, instance, value : Any):
        instance.__dict__[self.name] = value

    def __delete__(self, instance):
        raise AttributeError('Attribute "{:s}" cannot be deleted'.format(self.name))
