from typing import Any
from common.type_checkers.Checkers import chk_boolean, chk_not_none
from .Field import Field

class BooleanField(Field):
    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, type_=bool, **kwargs)

    def __set__(self, instance, value : bool) -> None:
        if self.required: chk_not_none(self.name, value)
        if value is None: super().__set__(instance, value)
        super().__set__(instance, chk_boolean(self.name, value))
