from typing import Dict, List, Set, Union

def get_or_create_dict(keys : Dict[str, Union[Dict, List, Set]], key_name : str) -> Dict:
    container = keys.get(key_name, None)
    if container is None: container = keys.setdefault(key_name, dict())
    if not isinstance(container, dict): raise Exception('Key({}) is not a dict'.format(key_name))
    return container

def get_or_create_list(keys : Dict[str, Union[Dict, List, Set]], key_name : str) -> List:
    container = keys.get(key_name, None)
    if container is None: container = keys.setdefault(key_name, list())
    if not isinstance(container, list): raise Exception('Key({}) is not a list'.format(key_name))
    return container

def get_or_create_set(keys : Dict[str, Union[Dict, List, Set]], key_name : str) -> Set:
    container = keys.get(key_name, None)
    if container is None: container = keys.setdefault(key_name, set())
    if not isinstance(container, set): raise Exception('Key({}) is not a set'.format(key_name))
    return container
