#!/usr/bin/python

import os
from concurrent import futures

import grpc
import numpy

import monitoring_pb2
import monitoring_pb2_grpc

import grpc.health.v1.health_pb2
import grpc.health.v1.health_pb2_grpc

from logger import getJSONLogger
logger = getJSONLogger('monitoringservice-server')
logger.setLevel('DEBUG')


import threading


class monitoringService(monitoring_pb2_grpc.MonitoringServiceServicer):
    def __init__(self):
        logger.info("init monitoringService")


    def IncludeKpi(self, request, context):
        #KPI, returns empty
        logger.info("IncludeKpi")
        return 


    def MonitorKpi ( self, request, context):
        #KpiDevice returns (google.protobuf.Empty) {}
        logger.info("IncludeKpi")
        return 

    def GetStream_kpi ( self, request, context):
        #KpiId ) returns (stream Kpi) {}
        logger.info("IncludeKpi")
        return 

    def GetInstantKpi ( self, request, context):
        #KpiId ) returns ( Kpi) {}
        logger.info("IncludeKpi")
        return   


if __name__ == "__main__":
    logger.info("initializing monitoringService")

    port = os.environ.get('PORT', "7070")

    # create gRPC server
    server = grpc.server(futures.ThreadPoolExecutor(max_workers=10)) # ,interceptors=(tracer_interceptor,))

    # add class to gRPC server
    service = MonitoringService()
    monitoring_pb2_grpc.add_MonitoringServiceServicer_to_server(service, server)

    health_servicer = health.HealthServicer(experimental_non_blocking=True,experimental_thread_pool=futures.ThreadPoolExecutor(max_workers=1))
    health_pb2_grpc.add_HealthServicer_to_server(health_servicer, server)

    # start server
    logger.info("listening on port: " + port)
    server.add_insecure_port('[::]:'+port)
    server.start()
    health_servicer.set("", health_pb2.HealthCheckResponse.SERVING)

    # keep alive
    try:
         while True:
            time.sleep(0.1)
    except KeyboardInterrupt:
            server.stop(0)

