import dateutil.parser
from datetime import datetime, timezone

def timestamp_string_to_float(str_timestamp : str) -> float:
    return datetime.timestamp(dateutil.parser.isoparse(str_timestamp))

def timestamp_float_to_string(flt_timestamp : float) -> str:
    return datetime.utcfromtimestamp(flt_timestamp).isoformat() + 'Z'

def timestamp_utcnow_to_float() -> float:
    return datetime.timestamp(datetime.now(tz=timezone.utc))
