# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_forwarding_direction import TapiCommonForwardingDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_routing_constraint import TapiPathComputationRoutingConstraint  # noqa: F401,E501
from tapi_server.models.tapi_topology_link_ref import TapiTopologyLinkRef  # noqa: F401,E501
from tapi_server import util


class TapiPathComputationPath(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, uuid: str=None, layer_protocol_name: TapiCommonLayerProtocolName=None, link: List[TapiTopologyLinkRef]=None, routing_constraint: TapiPathComputationRoutingConstraint=None, direction: TapiCommonForwardingDirection=None):  # noqa: E501
        """TapiPathComputationPath - a model defined in Swagger

        :param name: The name of this TapiPathComputationPath.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiPathComputationPath.  # noqa: E501
        :type uuid: str
        :param layer_protocol_name: The layer_protocol_name of this TapiPathComputationPath.  # noqa: E501
        :type layer_protocol_name: TapiCommonLayerProtocolName
        :param link: The link of this TapiPathComputationPath.  # noqa: E501
        :type link: List[TapiTopologyLinkRef]
        :param routing_constraint: The routing_constraint of this TapiPathComputationPath.  # noqa: E501
        :type routing_constraint: TapiPathComputationRoutingConstraint
        :param direction: The direction of this TapiPathComputationPath.  # noqa: E501
        :type direction: TapiCommonForwardingDirection
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'layer_protocol_name': TapiCommonLayerProtocolName,
            'link': List[TapiTopologyLinkRef],
            'routing_constraint': TapiPathComputationRoutingConstraint,
            'direction': TapiCommonForwardingDirection
        }

        self.attribute_map = {
            'name': 'name',
            'uuid': 'uuid',
            'layer_protocol_name': 'layer-protocol-name',
            'link': 'link',
            'routing_constraint': 'routing-constraint',
            'direction': 'direction'
        }
        self._name = name
        self._uuid = uuid
        self._layer_protocol_name = layer_protocol_name
        self._link = link
        self._routing_constraint = routing_constraint
        self._direction = direction

    @classmethod
    def from_dict(cls, dikt) -> 'TapiPathComputationPath':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.path.computation.Path of this TapiPathComputationPath.  # noqa: E501
        :rtype: TapiPathComputationPath
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiPathComputationPath.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiPathComputationPath.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiPathComputationPath.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiPathComputationPath.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiPathComputationPath.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiPathComputationPath.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiPathComputationPath.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiPathComputationPath.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def layer_protocol_name(self) -> TapiCommonLayerProtocolName:
        """Gets the layer_protocol_name of this TapiPathComputationPath.


        :return: The layer_protocol_name of this TapiPathComputationPath.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TapiCommonLayerProtocolName):
        """Sets the layer_protocol_name of this TapiPathComputationPath.


        :param layer_protocol_name: The layer_protocol_name of this TapiPathComputationPath.
        :type layer_protocol_name: TapiCommonLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def link(self) -> List[TapiTopologyLinkRef]:
        """Gets the link of this TapiPathComputationPath.

        none  # noqa: E501

        :return: The link of this TapiPathComputationPath.
        :rtype: List[TapiTopologyLinkRef]
        """
        return self._link

    @link.setter
    def link(self, link: List[TapiTopologyLinkRef]):
        """Sets the link of this TapiPathComputationPath.

        none  # noqa: E501

        :param link: The link of this TapiPathComputationPath.
        :type link: List[TapiTopologyLinkRef]
        """

        self._link = link

    @property
    def routing_constraint(self) -> TapiPathComputationRoutingConstraint:
        """Gets the routing_constraint of this TapiPathComputationPath.


        :return: The routing_constraint of this TapiPathComputationPath.
        :rtype: TapiPathComputationRoutingConstraint
        """
        return self._routing_constraint

    @routing_constraint.setter
    def routing_constraint(self, routing_constraint: TapiPathComputationRoutingConstraint):
        """Sets the routing_constraint of this TapiPathComputationPath.


        :param routing_constraint: The routing_constraint of this TapiPathComputationPath.
        :type routing_constraint: TapiPathComputationRoutingConstraint
        """

        self._routing_constraint = routing_constraint

    @property
    def direction(self) -> TapiCommonForwardingDirection:
        """Gets the direction of this TapiPathComputationPath.


        :return: The direction of this TapiPathComputationPath.
        :rtype: TapiCommonForwardingDirection
        """
        return self._direction

    @direction.setter
    def direction(self, direction: TapiCommonForwardingDirection):
        """Sets the direction of this TapiPathComputationPath.


        :param direction: The direction of this TapiPathComputationPath.
        :type direction: TapiCommonForwardingDirection
        """

        self._direction = direction
