# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_coordinate_type import TapiConnectivityCoordinateType  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_reversion_mode import TapiConnectivityReversionMode  # noqa: F401,E501
from tapi_server.models.tapi_topology_resilience_type import TapiTopologyResilienceType  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityResilienceConstraint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, is_lock_out: bool=False, max_switch_times: int=None, restoration_coordinate_type: TapiConnectivityCoordinateType=None, is_coordinated_switching_both_ends: bool=False, hold_off_time: int=None, is_frozen: bool=False, wait_to_revert_time: int=15, resilience_type: TapiTopologyResilienceType=None, preferred_restoration_layer: List[TapiCommonLayerProtocolName]=None, restore_priority: int=None, reversion_mode: TapiConnectivityReversionMode=None):  # noqa: E501
        """TapiConnectivityResilienceConstraint - a model defined in Swagger

        :param is_lock_out: The is_lock_out of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type is_lock_out: bool
        :param max_switch_times: The max_switch_times of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type max_switch_times: int
        :param restoration_coordinate_type: The restoration_coordinate_type of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type restoration_coordinate_type: TapiConnectivityCoordinateType
        :param is_coordinated_switching_both_ends: The is_coordinated_switching_both_ends of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type is_coordinated_switching_both_ends: bool
        :param hold_off_time: The hold_off_time of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type hold_off_time: int
        :param is_frozen: The is_frozen of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type is_frozen: bool
        :param wait_to_revert_time: The wait_to_revert_time of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type wait_to_revert_time: int
        :param resilience_type: The resilience_type of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type resilience_type: TapiTopologyResilienceType
        :param preferred_restoration_layer: The preferred_restoration_layer of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type preferred_restoration_layer: List[TapiCommonLayerProtocolName]
        :param restore_priority: The restore_priority of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type restore_priority: int
        :param reversion_mode: The reversion_mode of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :type reversion_mode: TapiConnectivityReversionMode
        """
        self.swagger_types = {
            'is_lock_out': bool,
            'max_switch_times': int,
            'restoration_coordinate_type': TapiConnectivityCoordinateType,
            'is_coordinated_switching_both_ends': bool,
            'hold_off_time': int,
            'is_frozen': bool,
            'wait_to_revert_time': int,
            'resilience_type': TapiTopologyResilienceType,
            'preferred_restoration_layer': List[TapiCommonLayerProtocolName],
            'restore_priority': int,
            'reversion_mode': TapiConnectivityReversionMode
        }

        self.attribute_map = {
            'is_lock_out': 'is-lock-out',
            'max_switch_times': 'max-switch-times',
            'restoration_coordinate_type': 'restoration-coordinate-type',
            'is_coordinated_switching_both_ends': 'is-coordinated-switching-both-ends',
            'hold_off_time': 'hold-off-time',
            'is_frozen': 'is-frozen',
            'wait_to_revert_time': 'wait-to-revert-time',
            'resilience_type': 'resilience-type',
            'preferred_restoration_layer': 'preferred-restoration-layer',
            'restore_priority': 'restore-priority',
            'reversion_mode': 'reversion-mode'
        }
        self._is_lock_out = is_lock_out
        self._max_switch_times = max_switch_times
        self._restoration_coordinate_type = restoration_coordinate_type
        self._is_coordinated_switching_both_ends = is_coordinated_switching_both_ends
        self._hold_off_time = hold_off_time
        self._is_frozen = is_frozen
        self._wait_to_revert_time = wait_to_revert_time
        self._resilience_type = resilience_type
        self._preferred_restoration_layer = preferred_restoration_layer
        self._restore_priority = restore_priority
        self._reversion_mode = reversion_mode

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityResilienceConstraint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.ResilienceConstraint of this TapiConnectivityResilienceConstraint.  # noqa: E501
        :rtype: TapiConnectivityResilienceConstraint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def is_lock_out(self) -> bool:
        """Gets the is_lock_out of this TapiConnectivityResilienceConstraint.

        The resource is configured to temporarily not be available for use in the protection scheme(s) it is part of.                  This overrides all other protection control states including forced.                  If the item is locked out then it cannot be used under any circumstances.                  Note: Only relevant when part of a protection scheme.  # noqa: E501

        :return: The is_lock_out of this TapiConnectivityResilienceConstraint.
        :rtype: bool
        """
        return self._is_lock_out

    @is_lock_out.setter
    def is_lock_out(self, is_lock_out: bool):
        """Sets the is_lock_out of this TapiConnectivityResilienceConstraint.

        The resource is configured to temporarily not be available for use in the protection scheme(s) it is part of.                  This overrides all other protection control states including forced.                  If the item is locked out then it cannot be used under any circumstances.                  Note: Only relevant when part of a protection scheme.  # noqa: E501

        :param is_lock_out: The is_lock_out of this TapiConnectivityResilienceConstraint.
        :type is_lock_out: bool
        """

        self._is_lock_out = is_lock_out

    @property
    def max_switch_times(self) -> int:
        """Gets the max_switch_times of this TapiConnectivityResilienceConstraint.

        Used to limit the maximum swtich times. When work fault disappears , and traffic return to the original work path, switch counter reset.  # noqa: E501

        :return: The max_switch_times of this TapiConnectivityResilienceConstraint.
        :rtype: int
        """
        return self._max_switch_times

    @max_switch_times.setter
    def max_switch_times(self, max_switch_times: int):
        """Sets the max_switch_times of this TapiConnectivityResilienceConstraint.

        Used to limit the maximum swtich times. When work fault disappears , and traffic return to the original work path, switch counter reset.  # noqa: E501

        :param max_switch_times: The max_switch_times of this TapiConnectivityResilienceConstraint.
        :type max_switch_times: int
        """

        self._max_switch_times = max_switch_times

    @property
    def restoration_coordinate_type(self) -> TapiConnectivityCoordinateType:
        """Gets the restoration_coordinate_type of this TapiConnectivityResilienceConstraint.


        :return: The restoration_coordinate_type of this TapiConnectivityResilienceConstraint.
        :rtype: TapiConnectivityCoordinateType
        """
        return self._restoration_coordinate_type

    @restoration_coordinate_type.setter
    def restoration_coordinate_type(self, restoration_coordinate_type: TapiConnectivityCoordinateType):
        """Sets the restoration_coordinate_type of this TapiConnectivityResilienceConstraint.


        :param restoration_coordinate_type: The restoration_coordinate_type of this TapiConnectivityResilienceConstraint.
        :type restoration_coordinate_type: TapiConnectivityCoordinateType
        """

        self._restoration_coordinate_type = restoration_coordinate_type

    @property
    def is_coordinated_switching_both_ends(self) -> bool:
        """Gets the is_coordinated_switching_both_ends of this TapiConnectivityResilienceConstraint.

        Is operating such that switching at both ends of each flow acorss the FC is coordinated at both ingress and egress ends.  # noqa: E501

        :return: The is_coordinated_switching_both_ends of this TapiConnectivityResilienceConstraint.
        :rtype: bool
        """
        return self._is_coordinated_switching_both_ends

    @is_coordinated_switching_both_ends.setter
    def is_coordinated_switching_both_ends(self, is_coordinated_switching_both_ends: bool):
        """Sets the is_coordinated_switching_both_ends of this TapiConnectivityResilienceConstraint.

        Is operating such that switching at both ends of each flow acorss the FC is coordinated at both ingress and egress ends.  # noqa: E501

        :param is_coordinated_switching_both_ends: The is_coordinated_switching_both_ends of this TapiConnectivityResilienceConstraint.
        :type is_coordinated_switching_both_ends: bool
        """

        self._is_coordinated_switching_both_ends = is_coordinated_switching_both_ends

    @property
    def hold_off_time(self) -> int:
        """Gets the hold_off_time of this TapiConnectivityResilienceConstraint.

        This attribute indicates the time, in milliseconds, between declaration of signal degrade or signal fail, and the initialization of the protection switching algorithm.  # noqa: E501

        :return: The hold_off_time of this TapiConnectivityResilienceConstraint.
        :rtype: int
        """
        return self._hold_off_time

    @hold_off_time.setter
    def hold_off_time(self, hold_off_time: int):
        """Sets the hold_off_time of this TapiConnectivityResilienceConstraint.

        This attribute indicates the time, in milliseconds, between declaration of signal degrade or signal fail, and the initialization of the protection switching algorithm.  # noqa: E501

        :param hold_off_time: The hold_off_time of this TapiConnectivityResilienceConstraint.
        :type hold_off_time: int
        """

        self._hold_off_time = hold_off_time

    @property
    def is_frozen(self) -> bool:
        """Gets the is_frozen of this TapiConnectivityResilienceConstraint.

        Temporarily prevents any switch action to be taken and, as such, freezes the current state.                   Until the freeze is cleared, additional near-end external commands are rejected and fault condition changes and received APS messages are ignored.                  All administrative controls of any aspect of protection are rejected.  # noqa: E501

        :return: The is_frozen of this TapiConnectivityResilienceConstraint.
        :rtype: bool
        """
        return self._is_frozen

    @is_frozen.setter
    def is_frozen(self, is_frozen: bool):
        """Sets the is_frozen of this TapiConnectivityResilienceConstraint.

        Temporarily prevents any switch action to be taken and, as such, freezes the current state.                   Until the freeze is cleared, additional near-end external commands are rejected and fault condition changes and received APS messages are ignored.                  All administrative controls of any aspect of protection are rejected.  # noqa: E501

        :param is_frozen: The is_frozen of this TapiConnectivityResilienceConstraint.
        :type is_frozen: bool
        """

        self._is_frozen = is_frozen

    @property
    def wait_to_revert_time(self) -> int:
        """Gets the wait_to_revert_time of this TapiConnectivityResilienceConstraint.

        If the protection system is revertive, this attribute specifies the time, in minutes, to wait after a fault clears on a higher priority (preferred) resource before reverting to the preferred resource.  # noqa: E501

        :return: The wait_to_revert_time of this TapiConnectivityResilienceConstraint.
        :rtype: int
        """
        return self._wait_to_revert_time

    @wait_to_revert_time.setter
    def wait_to_revert_time(self, wait_to_revert_time: int):
        """Sets the wait_to_revert_time of this TapiConnectivityResilienceConstraint.

        If the protection system is revertive, this attribute specifies the time, in minutes, to wait after a fault clears on a higher priority (preferred) resource before reverting to the preferred resource.  # noqa: E501

        :param wait_to_revert_time: The wait_to_revert_time of this TapiConnectivityResilienceConstraint.
        :type wait_to_revert_time: int
        """

        self._wait_to_revert_time = wait_to_revert_time

    @property
    def resilience_type(self) -> TapiTopologyResilienceType:
        """Gets the resilience_type of this TapiConnectivityResilienceConstraint.


        :return: The resilience_type of this TapiConnectivityResilienceConstraint.
        :rtype: TapiTopologyResilienceType
        """
        return self._resilience_type

    @resilience_type.setter
    def resilience_type(self, resilience_type: TapiTopologyResilienceType):
        """Sets the resilience_type of this TapiConnectivityResilienceConstraint.


        :param resilience_type: The resilience_type of this TapiConnectivityResilienceConstraint.
        :type resilience_type: TapiTopologyResilienceType
        """

        self._resilience_type = resilience_type

    @property
    def preferred_restoration_layer(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the preferred_restoration_layer of this TapiConnectivityResilienceConstraint.

        Indicate which layer this resilience parameters package configured for.  # noqa: E501

        :return: The preferred_restoration_layer of this TapiConnectivityResilienceConstraint.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._preferred_restoration_layer

    @preferred_restoration_layer.setter
    def preferred_restoration_layer(self, preferred_restoration_layer: List[TapiCommonLayerProtocolName]):
        """Sets the preferred_restoration_layer of this TapiConnectivityResilienceConstraint.

        Indicate which layer this resilience parameters package configured for.  # noqa: E501

        :param preferred_restoration_layer: The preferred_restoration_layer of this TapiConnectivityResilienceConstraint.
        :type preferred_restoration_layer: List[TapiCommonLayerProtocolName]
        """

        self._preferred_restoration_layer = preferred_restoration_layer

    @property
    def restore_priority(self) -> int:
        """Gets the restore_priority of this TapiConnectivityResilienceConstraint.

        none  # noqa: E501

        :return: The restore_priority of this TapiConnectivityResilienceConstraint.
        :rtype: int
        """
        return self._restore_priority

    @restore_priority.setter
    def restore_priority(self, restore_priority: int):
        """Sets the restore_priority of this TapiConnectivityResilienceConstraint.

        none  # noqa: E501

        :param restore_priority: The restore_priority of this TapiConnectivityResilienceConstraint.
        :type restore_priority: int
        """

        self._restore_priority = restore_priority

    @property
    def reversion_mode(self) -> TapiConnectivityReversionMode:
        """Gets the reversion_mode of this TapiConnectivityResilienceConstraint.


        :return: The reversion_mode of this TapiConnectivityResilienceConstraint.
        :rtype: TapiConnectivityReversionMode
        """
        return self._reversion_mode

    @reversion_mode.setter
    def reversion_mode(self, reversion_mode: TapiConnectivityReversionMode):
        """Sets the reversion_mode of this TapiConnectivityResilienceConstraint.


        :param reversion_mode: The reversion_mode of this TapiConnectivityResilienceConstraint.
        :type reversion_mode: TapiConnectivityReversionMode
        """

        self._reversion_mode = reversion_mode
