# Copyright 2022-2024 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, signal, sys, threading
from prometheus_client import start_http_server
from common.Settings  import get_log_level, get_metrics_port
from .PcepService import PcepService
from .tools.GrpcServer import GrpcServer
import socket
import subprocess



terminate = threading.Event()
LOGGER = logging.getLogger(__name__)

def signal_handler(signal, frame): # pylint: disable=redefined-outer-name
    LOGGER.warning('Terminate signal received')
    LOGGER.warning(signal)
    terminate.set()

def main():
    global LOGGER # pylint: disable=global-statement
    log_level = get_log_level()
    logging.basicConfig(level=log_level, format="[%(asctime)s] %(levelname)s:%(name)s:%(message)s")
    LOGGER = logging.getLogger(__name__)

    signal.signal(signal.SIGINT,  signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    LOGGER.info('Starting... (MAIN.py)')

    # Start metrics server
    metrics_port = get_metrics_port()
    start_http_server(metrics_port)

    # Initialize ServiceHandler Factory
    #service_handler_factory = ServiceHandlerFactory(SERVICE_HANDLERS)

    pcep_server = GrpcServer()                                                  #Create instance of the GRPC Server
    # pcep_server.Connect() 


    
    # def get_load_balancer_ip():
    #     command = ["kubectl", "get", "svc", "pcepservice", "-n", "tfs", "-o", "jsonpath='{.status.loadBalancer.ingress[0].ip}'"]
    #     result = subprocess.run(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    #     if result.returncode == 0:
    #         return result.stdout.decode('utf-8').strip()
    #     else:
    #         return None


    # ip_address = get_load_balancer_ip()
    #   
    # service_name = "pcepservice.tfs.svc.cluster.local"
    #ip_address = socket.gethostbyname(service_name)
    
    ip_address = socket.gethostbyname(socket.gethostname())

    LOGGER.debug("IP address of the PCEP POD: %s", ip_address)
    LOGGER.debug(ip_address)
    
    pcep_server.connectToJavaPcep(ip_address)
  
    # Starting pcep service
    pcep_service = PcepService(pcep_server)
    pcep_service.start()

    # Wait for Ctrl+C or termination signal
    while not terminate.wait(timeout=0.1): pass
    LOGGER.info('Terminating...')
    pcep_server.terminateGrpcServer()
    pcep_service.stop()

    LOGGER.info('Bye')
    return 0

if __name__ == '__main__':
    sys.exit(main())
