/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardedJedisPipeline
extends Queable {
    private BinaryShardedJedis jedis;
    private List<FutureResult> results = new ArrayList<FutureResult>();
    private Queue<Client> clients = new LinkedList<Client>();

    public void setShardedJedis(BinaryShardedJedis jedis) {
        this.jedis = jedis;
    }

    public Response<String> set(String key, String value) {
        Client c = this.getClient(key);
        c.set(key, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> get(String key) {
        Client c = this.getClient(key);
        c.get(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Boolean> exists(String key) {
        Client c = this.getClient(key);
        c.exists(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Boolean> type(String key) {
        Client c = this.getClient(key);
        c.type(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> expire(String key, int seconds) {
        Client c = this.getClient(key);
        c.expire(key, seconds);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> expireAt(String key, long unixTime) {
        Client c = this.getClient(key);
        c.expireAt(key, unixTime);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> ttl(String key) {
        Client c = this.getClient(key);
        c.ttl(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> getSet(String key, String value) {
        Client c = this.getClient(key);
        c.getSet(key, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> setnx(String key, String value) {
        Client c = this.getClient(key);
        c.setnx(key, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> setex(String key, int seconds, String value) {
        Client c = this.getClient(key);
        c.setex(key, seconds, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> decrBy(String key, long integer) {
        Client c = this.getClient(key);
        c.decrBy(key, integer);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> decr(String key) {
        Client c = this.getClient(key);
        c.decr(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> incrBy(String key, int integer) {
        Client c = this.getClient(key);
        c.incrBy(key, (long)integer);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> incr(String key) {
        Client c = this.getClient(key);
        c.incr(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> append(String key, String value) {
        Client c = this.getClient(key);
        c.append(key, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> substr(String key, int start, int end) {
        Client c = this.getClient(key);
        c.substr(key, start, end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hset(String key, String field, String value) {
        Client c = this.getClient(key);
        c.hset(key, field, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> hget(String key, String field) {
        Client c = this.getClient(key);
        c.hget(key, field);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hsetnx(String key, String field, String value) {
        Client c = this.getClient(key);
        c.hsetnx(key, field, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> hmset(String key, Map<String, String> hash) {
        Client c = this.getClient(key);
        c.hmset(key, hash);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<String>> hmget(String key, String ... fields) {
        Client c = this.getClient(key);
        c.hmget(key, fields);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> hincrBy(String key, String field, int value) {
        Client c = this.getClient(key);
        c.hincrBy(key, field, (long)value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> hexists(String key, String field) {
        Client c = this.getClient(key);
        c.hexists(key, field);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> hdel(String key, String field) {
        Client c = this.getClient(key);
        c.hdel(key, field);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> hlen(String key) {
        Client c = this.getClient(key);
        c.hlen(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> hkeys(String key) {
        Client c = this.getClient(key);
        c.hkeys(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Set<String>> hvals(String key) {
        Client c = this.getClient(key);
        c.hvals(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Map<String, String>> hgetAll(String key) {
        Client c = this.getClient(key);
        c.hgetAll(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    public Response<Long> rpush(String key, String string) {
        Client c = this.getClient(key);
        c.rpush(key, string);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> lpush(String key, String string) {
        Client c = this.getClient(key);
        c.lpush(key, string);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> llen(String key) {
        Client c = this.getClient(key);
        c.llen(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> lrange(String key, int start, int end) {
        Client c = this.getClient(key);
        c.lrange(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<String> ltrim(String key, int start, int end) {
        Client c = this.getClient(key);
        c.ltrim(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> lindex(String key, int index) {
        Client c = this.getClient(key);
        c.lindex(key, (long)index);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> lset(String key, int index, String value) {
        Client c = this.getClient(key);
        c.lset(key, (long)index, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> lrem(String key, int count, String value) {
        Client c = this.getClient(key);
        c.lrem(key, (long)count, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> lpop(String key) {
        Client c = this.getClient(key);
        c.lpop(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> rpop(String key) {
        Client c = this.getClient(key);
        c.rpop(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> sadd(String key, String member) {
        Client c = this.getClient(key);
        c.sadd(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> smembers(String key) {
        Client c = this.getClient(key);
        c.smembers(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> srem(String key, String member) {
        Client c = this.getClient(key);
        c.srem(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> spop(String key) {
        Client c = this.getClient(key);
        c.spop(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> scard(String key) {
        Client c = this.getClient(key);
        c.scard(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> sismember(String key, String member) {
        Client c = this.getClient(key);
        c.sismember(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> srandmember(String key) {
        Client c = this.getClient(key);
        c.srandmember(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> zadd(String key, double score, String member) {
        Client c = this.getClient(key);
        c.zadd(key, score, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrange(String key, int start, int end) {
        Client c = this.getClient(key);
        c.zrange(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Long> zrem(String key, String member) {
        Client c = this.getClient(key);
        c.zrem(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zincrby(String key, double score, String member) {
        Client c = this.getClient(key);
        c.zincrby(key, score, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Long> zrank(String key, String member) {
        Client c = this.getClient(key);
        c.zrank(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zrevrank(String key, String member) {
        Client c = this.getClient(key);
        c.zrevrank(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrevrange(String key, int start, int end) {
        Client c = this.getClient(key);
        c.zrevrange(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrangeWithScores(String key, int start, int end) {
        Client c = this.getClient(key);
        c.zrangeWithScores(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrevrangeWithScores(String key, int start, int end) {
        Client c = this.getClient(key);
        c.zrevrangeWithScores(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zcard(String key) {
        Client c = this.getClient(key);
        c.zcard(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zscore(String key, String member) {
        Client c = this.getClient(key);
        c.zscore(key, member);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Double> sort(String key) {
        Client c = this.getClient(key);
        c.sort(key);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        Client c = this.getClient(key);
        c.sort(key, sortingParameters);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> zcount(String key, double min2, double max) {
        Client c = this.getClient(key);
        c.zcount(key, min2, max);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrangeByScore(String key, double min2, double max) {
        Client c = this.getClient(key);
        c.zrangeByScore(key, min2, max);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(String key, double min2, double max, int offset, int count) {
        Client c = this.getClient(key);
        c.zrangeByScore(key, min2, max, offset, count);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min2, double max) {
        Client c = this.getClient(key);
        c.zrangeByScoreWithScores(key, min2, max);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min2, double max, int offset, int count) {
        Client c = this.getClient(key);
        c.zrangeByScoreWithScores(key, min2, max, offset, count);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zremrangeByRank(String key, int start, int end) {
        Client c = this.getClient(key);
        c.zremrangeByRank(key, (long)start, (long)end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByScore(String key, double start, double end) {
        Client c = this.getClient(key);
        c.zremrangeByScore(key, start, end);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Client c = this.getClient(key);
        c.linsert(key, where, pivot, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> getbit(String key, long offset) {
        Client c = this.getClient(key);
        c.getbit(key, offset);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Boolean> setbit(String key, long offset, boolean value) {
        Client c = this.getClient(key);
        c.setbit(key, offset, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> setrange(String key, long offset, String value) {
        Client c = this.getClient(key);
        c.setrange(key, offset, value);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> getrange(String key, long startOffset, long endOffset) {
        Client c = this.getClient(key);
        c.getrange(key, startOffset, endOffset);
        this.results.add(new FutureResult(c));
        return this.getResponse(BuilderFactory.LONG);
    }

    public List<Object> getResults() {
        ArrayList<Object> r = new ArrayList<Object>();
        for (FutureResult fr : this.results) {
            r.add(fr.get());
        }
        return r;
    }

    public void sync() {
        for (Client client : this.clients) {
            this.generateResponse(client.getOne());
        }
    }

    public List<Object> syncAndReturnAll() {
        ArrayList<Object> formatted = new ArrayList<Object>();
        for (Client client : this.clients) {
            formatted.add(this.generateResponse(client.getOne()).get());
        }
        return formatted;
    }

    @Deprecated
    public void execute() {
    }

    private Client getClient(String key) {
        Client client = ((Jedis)this.jedis.getShard(key)).getClient();
        this.clients.add(client);
        return client;
    }

    private static class FutureResult {
        private Client client;

        public FutureResult(Client client) {
            this.client = client;
        }

        public Object get() {
            return this.client.getOne();
        }
    }
}

