/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Client;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBlock;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.JedisByteHashMap;
import redis.clients.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryJedis
implements BinaryJedisCommands {
    protected Client client = null;

    public BinaryJedis(String host) {
        this.client = new Client(host);
    }

    public BinaryJedis(String host, int port) {
        this.client = new Client(host, port);
    }

    public BinaryJedis(String host, int port, int timeout) {
        this.client = new Client(host, port);
        this.client.setTimeout(timeout);
    }

    public BinaryJedis(JedisShardInfo shardInfo) {
        this.client = new Client(shardInfo.getHost(), shardInfo.getPort());
        this.client.setTimeout(shardInfo.getTimeout());
        this.client.setPassword(shardInfo.getPassword());
    }

    public String ping() {
        this.checkIsInMulti();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] get(byte[] key) {
        this.checkIsInMulti();
        this.client.get(key);
        return this.client.getBinaryBulkReply();
    }

    public String quit() {
        this.checkIsInMulti();
        this.client.quit();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Boolean exists(byte[] key) {
        this.checkIsInMulti();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    public Long del(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(byte[] key) {
        this.checkIsInMulti();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    public String flushDB() {
        this.checkIsInMulti();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    public Set<byte[]> keys(byte[] pattern) {
        this.checkIsInMulti();
        this.client.keys(pattern);
        HashSet<byte[]> keySet = new HashSet<byte[]>(this.client.getBinaryMultiBulkReply());
        return keySet;
    }

    public byte[] randomBinaryKey() {
        this.checkIsInMulti();
        this.client.randomKey();
        return this.client.getBinaryBulkReply();
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkIsInMulti();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkIsInMulti();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    public Long dbSize() {
        this.checkIsInMulti();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        this.checkIsInMulti();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        this.checkIsInMulti();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(byte[] key) {
        this.checkIsInMulti();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    public String select(int index) {
        this.checkIsInMulti();
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    public Long move(byte[] key, int dbIndex) {
        this.checkIsInMulti();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    public String flushAll() {
        this.checkIsInMulti();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.getSet(key, value);
        return this.client.getBinaryBulkReply();
    }

    public List<byte[]> mget(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.mget(keys);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        this.checkIsInMulti();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    public String mset(byte[] ... keysvalues) {
        this.checkIsInMulti();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public Long msetnx(byte[] ... keysvalues) {
        this.checkIsInMulti();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(byte[] key, long integer) {
        this.checkIsInMulti();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(byte[] key) {
        this.checkIsInMulti();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(byte[] key, long integer) {
        this.checkIsInMulti();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incr(byte[] key) {
        this.checkIsInMulti();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        this.checkIsInMulti();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.substr(key, start, end);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMulti();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        this.checkIsInMulti();
        this.client.hget(key, field);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMulti();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMulti();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.checkIsInMulti();
        this.client.hmget(key, fields);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        this.checkIsInMulti();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        this.checkIsInMulti();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        this.checkIsInMulti();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(byte[] key) {
        this.checkIsInMulti();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        this.checkIsInMulti();
        this.client.hkeys(key);
        List<byte[]> lresult = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(lresult);
    }

    public List<byte[]> hvals(byte[] key) {
        this.checkIsInMulti();
        this.client.hvals(key);
        List<byte[]> lresult = this.client.getBinaryMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.checkIsInMulti();
        this.client.hgetAll(key);
        List<byte[]> flatHash = this.client.getBinaryMultiBulkReply();
        JedisByteHashMap hash = new JedisByteHashMap();
        Iterator<byte[]> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        this.checkIsInMulti();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        this.checkIsInMulti();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(byte[] key) {
        this.checkIsInMulti();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> lrange(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.lrange(key, (long)start, (long)end);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String ltrim(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.ltrim(key, (long)start, (long)end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] lindex(byte[] key, int index) {
        this.checkIsInMulti();
        this.client.lindex(key, (long)index);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String lset(byte[] key, int index, byte[] value) {
        this.checkIsInMulti();
        this.client.lset(key, (long)index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(byte[] key, int count, byte[] value) {
        this.checkIsInMulti();
        this.client.lrem(key, (long)count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] lpop(byte[] key) {
        this.checkIsInMulti();
        this.client.lpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpop(byte[] key) {
        this.checkIsInMulti();
        this.client.rpop(key);
        return this.client.getBinaryBulkReply();
    }

    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        this.checkIsInMulti();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members) {
        this.checkIsInMulti();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        this.checkIsInMulti();
        this.client.smembers(key);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    @Override
    public Long srem(byte[] key, byte[] ... member) {
        this.checkIsInMulti();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] spop(byte[] key) {
        this.checkIsInMulti();
        this.client.spop(key);
        return this.client.getBinaryBulkReply();
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.checkIsInMulti();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(byte[] key) {
        this.checkIsInMulti();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sinter(keys);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sunion(keys);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sdiff(keys);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new HashSet<byte[]>(members);
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMulti();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] srandmember(byte[] key) {
        this.checkIsInMulti();
        this.client.srandmember(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        this.checkIsInMulti();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<Double, byte[]> scoreMembers) {
        this.checkIsInMulti();
        this.client.zaddBinary(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrange(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrange(key, (long)start, (long)end);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new LinkedHashSet<byte[]>(members);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members) {
        this.checkIsInMulti();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        this.checkIsInMulti();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrevrange(key, (long)start, (long)end);
        List<byte[]> members = this.client.getBinaryMultiBulkReply();
        return new LinkedHashSet<byte[]>(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrangeWithScores(key, (long)start, (long)end);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrevrangeWithScores(key, (long)start, (long)end);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Long zcard(byte[] key) {
        this.checkIsInMulti();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        this.checkIsInMulti();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    public Transaction multi() {
        this.client.multi();
        return new Transaction(this.client);
    }

    public List<Object> multi(TransactionBlock jedisTransaction) {
        List<Object> results = null;
        jedisTransaction.setClient(this.client);
        try {
            this.client.multi();
            jedisTransaction.execute();
            results = jedisTransaction.exec();
        }
        catch (Exception ex) {
            jedisTransaction.discard();
        }
        return results;
    }

    protected void checkIsInMulti() {
        if (this.client.isInMulti()) {
            throw new JedisDataException("Cannot use Jedis when in Multi. Please use JedisTransaction instead.");
        }
    }

    public void connect() {
        this.client.connect();
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public String watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    public String unwatch() {
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        this.checkIsInMulti();
        this.client.sort(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters);
        return this.client.getBinaryMultiBulkReply();
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        this.checkIsInMulti();
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.client.blpop((byte[][])args.toArray((T[])new byte[args.size()][]));
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    public Long sort(byte[] key, byte[] dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        this.checkIsInMulti();
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.client.brpop((byte[][])args.toArray((T[])new byte[args.size()][]));
        this.client.setTimeoutInfinite();
        List<byte[]> multiBulkReply = this.client.getBinaryMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    public String auth(String password) {
        this.checkIsInMulti();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    public List<Object> pipelined(PipelineBlock jedisPipeline) {
        jedisPipeline.setClient(this.client);
        jedisPipeline.execute();
        return jedisPipeline.syncAndReturnAll();
    }

    public Pipeline pipelined() {
        Pipeline pipeline = new Pipeline();
        pipeline.setClient(this.client);
        return pipeline;
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceed(this.client, channels);
        this.client.rollbackTimeout();
    }

    public Long publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceedWithPatterns(this.client, patterns);
        this.client.rollbackTimeout();
    }

    @Override
    public Long zcount(byte[] key, double min2, double max) {
        return this.zcount(key, Protocol.toByteArray(min2), Protocol.toByteArray(max));
    }

    @Override
    public Long zcount(byte[] key, byte[] min2, byte[] max) {
        this.checkIsInMulti();
        this.client.zcount(key, min2, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max) {
        return this.zrangeByScore(key, Protocol.toByteArray(min2), Protocol.toByteArray(max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min2, max);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max, int offset, int count) {
        return this.zrangeByScore(key, Protocol.toByteArray(min2), Protocol.toByteArray(max), offset, count);
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min2, max, offset, count);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min2), Protocol.toByteArray(max));
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min2, max);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max, int offset, int count) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min2), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min2, max, offset, count);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    private Set<Tuple> getBinaryTupledSet() {
        this.checkIsInMulti();
        List<byte[]> membersWithScores = this.client.getBinaryMultiBulkReply();
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>();
        Iterator<byte[]> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(SafeEncoder.encode(iterator.next()))));
        }
        return set;
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min2) {
        return this.zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min2));
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min2) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min2);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min2, int offset, int count) {
        return this.zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min2), offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min2, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min2, offset, count);
        return new LinkedHashSet<byte[]>(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min2) {
        return this.zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min2));
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min2, int offset, int count) {
        return this.zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min2), offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min2) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min2);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min2, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min2, offset, count);
        Set<Tuple> set = this.getBinaryTupledSet();
        return set;
    }

    @Override
    public Long zremrangeByRank(byte[] key, int start, int end) {
        this.checkIsInMulti();
        this.client.zremrangeByRank(key, (long)start, (long)end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        return this.zremrangeByScore(key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    public Long lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    public String shutdown() {
        this.client.shutdown();
        String status2 = null;
        try {
            status2 = this.client.getStatusCodeReply();
        }
        catch (JedisException ex) {
            status2 = null;
        }
        return status2;
    }

    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.client.monitor();
        jedisMonitor.proceed(this.client);
    }

    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    public List<byte[]> configGet(byte[] pattern) {
        this.client.configGet(pattern);
        return this.client.getBinaryMultiBulkReply();
    }

    public String configResetStat() {
        this.client.configResetStat();
        return this.client.getStatusCodeReply();
    }

    public byte[] configSet(byte[] parameter, byte[] value) {
        this.client.configSet(parameter, value);
        return this.client.getBinaryBulkReply();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public Long strlen(byte[] key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    public void sync() {
        this.client.sync();
    }

    @Override
    public Long lpushx(byte[] key, byte[] string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    public Long persist(byte[] key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(byte[] key, byte[] string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    public byte[] echo(byte[] string) {
        this.client.echo(string);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    public String debug(DebugParams params) {
        this.client.debug(params);
        return this.client.getStatusCodeReply();
    }

    public Client getClient() {
        return this.client;
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        byte[] reply = this.client.getBinaryBulkReply();
        this.client.rollbackTimeout();
        return reply;
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    public Boolean getbit(byte[] key, long offset) {
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    public String getrange(byte[] key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBulkReply();
    }

    public Long publish(byte[] channel, byte[] message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceed(this.client, channels);
        this.client.rollbackTimeout();
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceedWithPatterns(this.client, patterns);
        this.client.rollbackTimeout();
    }

    public Long getDB() {
        return this.client.getDB();
    }

    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, Protocol.toByteArray(keys.size()), this.getParams(keys, args));
        return this.client.getOne();
    }

    private byte[][] getParams(List<byte[]> keys, List<byte[]> args) {
        int i;
        int keyCount = keys.size();
        byte[][] params = new byte[keyCount + args.size()][];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < keys.size(); ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    public Object eval(byte[] script, byte[] keyCount, byte[][] params) {
        this.client.setTimeoutInfinite();
        this.client.eval(script, keyCount, params);
        return this.client.getOne();
    }

    public byte[] scriptFlush() {
        this.client.scriptFlush();
        return this.client.getBinaryBulkReply();
    }

    public List<Long> scriptExists(byte[] ... sha1) {
        this.client.scriptExists(sha1);
        return this.client.getIntegerMultiBulkReply();
    }

    public byte[] scriptLoad(byte[] script) {
        this.client.scriptLoad(script);
        return this.client.getBinaryBulkReply();
    }

    public byte[] scriptKill() {
        this.client.scriptKill();
        return this.client.getBinaryBulkReply();
    }

    public byte[] slowlogReset() {
        this.client.slowlogReset();
        return this.client.getBinaryBulkReply();
    }

    public long slowlogLen() {
        this.client.slowlogLen();
        return this.client.getIntegerReply();
    }

    public List<byte[]> slowlogGetBinary() {
        this.client.slowlogGet();
        return this.client.getBinaryMultiBulkReply();
    }

    public List<byte[]> slowlogGetBinary(long entries) {
        this.client.slowlogGet(entries);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] key) {
        this.client.objectEncoding(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }
}

