/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.HashSet;
import java.util.LinkedList;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public final class GraphTests<V, E> {
    private GraphTests() {
    }

    public static <V, E> boolean isEmpty(Graph<V, E> g2) {
        return g2.edgeSet().isEmpty();
    }

    public static <V, E> boolean isComplete(Graph<V, E> g2) {
        int n = g2.vertexSet().size();
        return g2.edgeSet().size() == n * (n - 1) / 2;
    }

    public static <V, E> boolean isConnected(Graph<V, E> g2) {
        int numVertices = g2.vertexSet().size();
        int numEdges = g2.edgeSet().size();
        if (numEdges < numVertices - 1) {
            return false;
        }
        if (numVertices < 2 || numEdges > (numVertices - 1) * (numVertices - 2) / 2) {
            return true;
        }
        HashSet<V> known = new HashSet<V>();
        LinkedList<V> queue = new LinkedList<V>();
        Object v2 = g2.vertexSet().iterator().next();
        queue.add(v2);
        known.add(v2);
        while (!queue.isEmpty()) {
            v2 = queue.removeFirst();
            for (Object v2 : Graphs.neighborListOf(g2, v2)) {
                if (known.contains(v2)) continue;
                known.add(v2);
                queue.add(v2);
            }
        }
        return known.size() == numVertices;
    }

    public static <V, E> boolean isTree(Graph<V, E> g2) {
        return GraphTests.isConnected(g2) && g2.edgeSet().size() == g2.vertexSet().size() - 1;
    }

    public static <V, E> boolean isBipartite(Graph<V, E> g2) {
        if (4 * g2.edgeSet().size() > g2.vertexSet().size() * g2.vertexSet().size()) {
            return false;
        }
        if (GraphTests.isEmpty(g2)) {
            return true;
        }
        HashSet<V> unknown = new HashSet<V>(g2.vertexSet());
        LinkedList<Object> queue = new LinkedList<Object>();
        Object v = unknown.iterator().next();
        HashSet<V> odd = new HashSet<V>();
        queue.add(v);
        while (!unknown.isEmpty()) {
            if (queue.isEmpty()) {
                queue.add(unknown.iterator().next());
            }
            v = queue.removeFirst();
            unknown.remove(v);
            for (V n : Graphs.neighborListOf(g2, v)) {
                if (unknown.contains(n)) {
                    queue.add(n);
                    if (odd.contains(v)) continue;
                    odd.add(n);
                    continue;
                }
                if (odd.contains(v) ^ odd.contains(n)) continue;
                return false;
            }
        }
        return true;
    }
}

