/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractBaseGraph;

public class GraphSquare<V, E>
extends AbstractBaseGraph<V, E> {
    private static final long serialVersionUID = -2642034600395594304L;
    private static final String UNMODIFIABLE = "this graph is unmodifiable";

    public GraphSquare(final Graph<V, E> g2, final boolean createLoops) {
        super(g2.getEdgeFactory(), false, createLoops);
        Graphs.addAllVertices(this, g2.vertexSet());
        this.addSquareEdges(g2, createLoops);
        if (g2 instanceof ListenableGraph) {
            ((ListenableGraph)g2).addGraphListener(new GraphListener<V, E>(){

                @Override
                public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
                    Object edge = e.getEdge();
                    GraphSquare.this.addEdgesStartingAt(g2, g2.getEdgeSource(edge), g2.getEdgeTarget(edge), createLoops);
                    GraphSquare.this.addEdgesStartingAt(g2, g2.getEdgeTarget(edge), g2.getEdgeSource(edge), createLoops);
                }

                @Override
                public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
                    GraphSquare.super.removeAllEdges(GraphSquare.this.edgeSet());
                    GraphSquare.this.addSquareEdges(g2, createLoops);
                }

                @Override
                public void vertexAdded(GraphVertexChangeEvent<V> e) {
                }

                @Override
                public void vertexRemoved(GraphVertexChangeEvent<V> e) {
                }
            });
        }
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends E> edges) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public Set<E> removeAllEdges(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> vertices) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    private void addEdgesStartingAt(Graph<V, E> g2, V v, V u, boolean createLoops) {
        if (!g2.containsEdge(v, u)) {
            return;
        }
        List<V> adjVertices = Graphs.neighborListOf(g2, u);
        for (int i = 0; i < adjVertices.size(); ++i) {
            V w = adjVertices.get(i);
            if (!g2.containsEdge(u, w) || v == w && !createLoops) continue;
            super.addEdge(v, w);
        }
    }

    private void addSquareEdges(Graph<V, E> g2, boolean createLoops) {
        for (V v : g2.vertexSet()) {
            List<V> adjVertices = Graphs.neighborListOf(g2, v);
            for (int i = 0; i < adjVertices.size(); ++i) {
                this.addEdgesStartingAt(g2, v, adjVertices.get(i), createLoops);
            }
        }
    }
}

