/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.MinimumSpanningTree;

public class PrimMinimumSpanningTree<V, E>
implements MinimumSpanningTree<V, E> {
    private final Set<E> minimumSpanningTreeEdgeSet;
    private final double minimumSpanningTreeTotalWeight;

    public PrimMinimumSpanningTree(final Graph<V, E> g2) {
        this.minimumSpanningTreeEdgeSet = new HashSet(g2.vertexSet().size());
        HashSet<V> unspanned = new HashSet<V>(g2.vertexSet());
        while (!unspanned.isEmpty()) {
            Object next;
            Iterator ri = unspanned.iterator();
            Object root = ri.next();
            ri.remove();
            PriorityQueue<E> dangling = new PriorityQueue<E>(g2.edgeSet().size(), new Comparator<E>(){

                @Override
                public int compare(E lop, E rop) {
                    return Double.valueOf(g2.getEdgeWeight(lop)).compareTo(g2.getEdgeWeight(rop));
                }
            });
            dangling.addAll(g2.edgesOf(root));
            while ((next = dangling.poll()) != null) {
                V t;
                V s2 = g2.getEdgeSource(next);
                V v = t = unspanned.contains(s2) ? s2 : g2.getEdgeTarget(next);
                if (!unspanned.contains(t)) continue;
                this.minimumSpanningTreeEdgeSet.add(next);
                unspanned.remove(t);
                for (E e : g2.edgesOf(t)) {
                    if (!unspanned.contains(g2.getEdgeSource(e).equals(t) ? g2.getEdgeTarget(e) : g2.getEdgeSource(e))) continue;
                    dangling.add(e);
                }
            }
        }
        double spanningTreeWeight = 0.0;
        for (E e : this.minimumSpanningTreeEdgeSet) {
            spanningTreeWeight += g2.getEdgeWeight(e);
        }
        this.minimumSpanningTreeTotalWeight = spanningTreeWeight;
    }

    @Override
    public Set<E> getMinimumSpanningTreeEdgeSet() {
        return Collections.unmodifiableSet(this.minimumSpanningTreeEdgeSet);
    }

    @Override
    public double getMinimumSpanningTreeTotalWeight() {
        return this.minimumSpanningTreeTotalWeight;
    }
}

