/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.util.StringEncoder;

public abstract class AbstractStringLayout
extends AbstractLayout<String>
implements StringLayout {
    protected static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    private static final ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private transient Charset charset;
    private final String charsetName;
    private final boolean useCustomEncoding;

    protected AbstractStringLayout(Charset charset) {
        this(charset, null, null);
    }

    protected AbstractStringLayout(Charset charset, byte[] header, byte[] footer) {
        super(header, footer);
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
        this.charsetName = this.charset.name();
        this.useCustomEncoding = AbstractStringLayout.isPreJava8() && (StandardCharsets.ISO_8859_1.equals(charset) || StandardCharsets.US_ASCII.equals(charset));
    }

    private static boolean isPreJava8() {
        String version = System.getProperty("java.version");
        String[] parts = version.split("\\.");
        try {
            int major = Integer.parseInt(parts[1]);
            return major < 8;
        }
        catch (Exception ex) {
            return true;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.charset.name());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String csName = in.readUTF();
        this.charset = Charset.forName(csName);
    }

    protected StringBuilder getStringBuilder() {
        StringBuilder result = threadLocal.get();
        if (result == null) {
            result = new StringBuilder(1024);
            threadLocal.set(result);
        }
        result.setLength(0);
        return result;
    }

    protected byte[] getBytes(String s2) {
        if (this.useCustomEncoding) {
            return StringEncoder.encodeSingleByteChars(s2);
        }
        try {
            return s2.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return s2.getBytes(this.charset);
        }
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        return this.getBytes((String)this.toSerializable(event));
    }
}

