/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverterRegistry;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;

public final class TypeConverters {
    public static final String CATEGORY = "TypeConverter";
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static Object convert(String s2, Class<?> clazz, Object defaultValue) {
        TypeConverter<?> converter = TypeConverterRegistry.getInstance().findCompatibleConverter(clazz);
        if (s2 == null) {
            return TypeConverters.parseDefaultValue(converter, defaultValue);
        }
        try {
            return converter.convert(s2);
        }
        catch (Exception e) {
            LOGGER.warn("Error while converting string [{}] to type [{}]. Using default value [{}].", s2, clazz, defaultValue, e);
            return TypeConverters.parseDefaultValue(converter, defaultValue);
        }
    }

    private static Object parseDefaultValue(TypeConverter<?> converter, Object defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (!(defaultValue instanceof String)) {
            return defaultValue;
        }
        try {
            return converter.convert((String)defaultValue);
        }
        catch (Exception e) {
            LOGGER.debug("Can't parse default value [{}] for type [{}].", defaultValue, converter.getClass(), e);
            return null;
        }
    }

    @Plugin(name="URL", category="TypeConverter")
    public static class UrlConverter
    implements TypeConverter<URL> {
        @Override
        public URL convert(String s2) throws MalformedURLException {
            return new URL(s2);
        }
    }

    @Plugin(name="URI", category="TypeConverter")
    public static class UriConverter
    implements TypeConverter<URI> {
        @Override
        public URI convert(String s2) throws URISyntaxException {
            return new URI(s2);
        }
    }

    @Plugin(name="String", category="TypeConverter")
    public static class StringConverter
    implements TypeConverter<String> {
        @Override
        public String convert(String s2) {
            return s2;
        }
    }

    @Plugin(name="Short", category="TypeConverter")
    public static class ShortConverter
    implements TypeConverter<Short> {
        @Override
        public Short convert(String s2) {
            return Short.valueOf(s2);
        }
    }

    @Plugin(name="SecurityProvider", category="TypeConverter")
    public static class SecurityProviderConverter
    implements TypeConverter<Provider> {
        @Override
        public Provider convert(String s2) {
            return Security.getProvider(s2);
        }
    }

    @Plugin(name="Pattern", category="TypeConverter")
    public static class PatternConverter
    implements TypeConverter<Pattern> {
        @Override
        public Pattern convert(String s2) {
            return Pattern.compile(s2);
        }
    }

    @Plugin(name="Long", category="TypeConverter")
    public static class LongConverter
    implements TypeConverter<Long> {
        @Override
        public Long convert(String s2) {
            return Long.valueOf(s2);
        }
    }

    @Plugin(name="Level", category="TypeConverter")
    public static class LevelConverter
    implements TypeConverter<Level> {
        @Override
        public Level convert(String s2) {
            return Level.valueOf(s2);
        }
    }

    @Plugin(name="Integer", category="TypeConverter")
    public static class IntegerConverter
    implements TypeConverter<Integer> {
        @Override
        public Integer convert(String s2) {
            return Integer.valueOf(s2);
        }
    }

    @Plugin(name="Float", category="TypeConverter")
    public static class FloatConverter
    implements TypeConverter<Float> {
        @Override
        public Float convert(String s2) {
            return Float.valueOf(s2);
        }
    }

    @Plugin(name="File", category="TypeConverter")
    public static class FileConverter
    implements TypeConverter<File> {
        @Override
        public File convert(String s2) {
            return new File(s2);
        }
    }

    @Plugin(name="Duration", category="TypeConverter")
    public static class DurationConverter
    implements TypeConverter<Duration> {
        @Override
        public Duration convert(String s2) {
            return Duration.parse(s2);
        }
    }

    @Plugin(name="Double", category="TypeConverter")
    public static class DoubleConverter
    implements TypeConverter<Double> {
        @Override
        public Double convert(String s2) {
            return Double.valueOf(s2);
        }
    }

    @Plugin(name="CronExpression", category="TypeConverter")
    public static class CronExpressionConverter
    implements TypeConverter<CronExpression> {
        @Override
        public CronExpression convert(String s2) throws Exception {
            return new CronExpression(s2);
        }
    }

    @Plugin(name="Class", category="TypeConverter")
    public static class ClassConverter
    implements TypeConverter<Class<?>> {
        @Override
        public Class<?> convert(String s2) throws ClassNotFoundException {
            return Loader.loadClass(s2);
        }
    }

    @Plugin(name="Charset", category="TypeConverter")
    public static class CharsetConverter
    implements TypeConverter<Charset> {
        @Override
        public Charset convert(String s2) {
            return Charset.forName(s2);
        }
    }

    @Plugin(name="CharacterArray", category="TypeConverter")
    public static class CharArrayConverter
    implements TypeConverter<char[]> {
        @Override
        public char[] convert(String s2) {
            return s2.toCharArray();
        }
    }

    @Plugin(name="Character", category="TypeConverter")
    public static class CharacterConverter
    implements TypeConverter<Character> {
        @Override
        public Character convert(String s2) {
            if (s2.length() != 1) {
                throw new IllegalArgumentException("Character string must be of length 1: " + s2);
            }
            return Character.valueOf(s2.toCharArray()[0]);
        }
    }

    @Plugin(name="Byte", category="TypeConverter")
    public static class ByteConverter
    implements TypeConverter<Byte> {
        @Override
        public Byte convert(String s2) {
            return Byte.valueOf(s2);
        }
    }

    @Plugin(name="ByteArray", category="TypeConverter")
    public static class ByteArrayConverter
    implements TypeConverter<byte[]> {
        private static final String PREFIX_0x = "0x";
        private static final String PREFIX_BASE64 = "Base64:";

        @Override
        public byte[] convert(String value) {
            byte[] bytes;
            if (value == null || value.isEmpty()) {
                bytes = new byte[]{};
            } else if (value.startsWith(PREFIX_BASE64)) {
                String lexicalXSDBase64Binary = value.substring(PREFIX_BASE64.length());
                bytes = DatatypeConverter.parseBase64Binary((String)lexicalXSDBase64Binary);
            } else if (value.startsWith(PREFIX_0x)) {
                String lexicalXSDHexBinary = value.substring(PREFIX_0x.length());
                bytes = DatatypeConverter.parseHexBinary((String)lexicalXSDHexBinary);
            } else {
                bytes = value.getBytes(Charset.defaultCharset());
            }
            return bytes;
        }
    }

    @Plugin(name="Boolean", category="TypeConverter")
    public static class BooleanConverter
    implements TypeConverter<Boolean> {
        @Override
        public Boolean convert(String s2) {
            return Boolean.valueOf(s2);
        }
    }

    @Plugin(name="BigInteger", category="TypeConverter")
    public static class BigIntegerConverter
    implements TypeConverter<BigInteger> {
        @Override
        public BigInteger convert(String s2) {
            return new BigInteger(s2);
        }
    }

    @Plugin(name="BigDecimal", category="TypeConverter")
    public static class BigDecimalConverter
    implements TypeConverter<BigDecimal> {
        @Override
        public BigDecimal convert(String s2) {
            return new BigDecimal(s2);
        }
    }
}

