/*
 * Decompiled with CFR 0.152.
 */
package es.tid.util;

public class Analysis {
    private static final int NUM_BATCHES = 400;
    private static final int EVEN = 1;
    private static final int ODD = 0;
    private static final int HALF = 2;
    private static final double THRESHOLD = 0.4;
    private static final double GAMMA = 0.075;
    private static final double t_STUDENT = 1.96;
    private double[][] averages = new double[2][400];
    private double rohat;
    private int[] position_batch = new int[2];
    private long[] size_batch = new long[2];
    private int[] batch = new int[2];
    private long[] samples = new long[2];
    private int iter;
    private int converge;
    private double total_average;
    private double numerator_sy2;
    private long[] Max_samples = new long[2];

    public Analysis() {
        this.size_batch[1] = 3L;
        this.size_batch[0] = 2L;
        this.converge = 0;
        this.Max_samples[1] = 1200L;
        this.Max_samples[0] = 800L;
        this.samples[1] = 0L;
        this.samples[0] = 0L;
        this.position_batch[1] = 0;
        this.position_batch[0] = 0;
        this.averages[1][0] = 0.0;
        this.averages[0][0] = 0.0;
        this.batch[0] = 0;
        this.batch[1] = 0;
        this.total_average = 0.0;
        this.numerator_sy2 = 0.0;
        this.iter = 0;
    }

    public boolean analyze(double elem) {
        double rohatold;
        boolean end;
        boolean finalized_iteration = false;
        double[] dArray = this.averages[1];
        int n = this.batch[1];
        dArray[n] = dArray[n] + elem;
        double[] dArray2 = this.averages[0];
        int n2 = this.batch[0];
        dArray2[n2] = dArray2[n2] + elem;
        this.position_batch[1] = this.position_batch[1] + 1;
        this.position_batch[0] = this.position_batch[0] + 1;
        if ((long)this.position_batch[1] == this.size_batch[1]) {
            double[] dArray3 = this.averages[1];
            int n3 = this.batch[1];
            dArray3[n3] = dArray3[n3] / (double)this.size_batch[1];
            this.batch[1] = this.batch[1] + 1;
            this.position_batch[1] = 0;
            if (this.batch[1] < 400) {
                this.averages[1][this.batch[1]] = 0.0;
            }
        }
        if ((long)this.position_batch[0] == this.size_batch[0]) {
            double[] dArray4 = this.averages[0];
            int n4 = this.batch[0];
            dArray4[n4] = dArray4[n4] / (double)this.size_batch[0];
            this.batch[0] = this.batch[0] + 1;
            this.position_batch[0] = 0;
            if (this.batch[0] < 400) {
                this.averages[0][this.batch[0]] = 0.0;
            }
        }
        this.samples[1] = this.samples[1] + 1L;
        this.samples[0] = this.samples[0] + 1L;
        if (this.samples[1] == this.Max_samples[1]) {
            ++this.iter;
            this.calculate_rohat(1, 1);
            this.Max_samples[1] = this.Max_samples[1] * 2L;
            this.size_batch[1] = this.Max_samples[1] / 400L;
            this.calculate_averages(1);
            this.batch[1] = this.batch[1] / 2;
            this.averages[1][this.batch[1]] = 0.0;
            if (this.rohat <= 0.0) {
                end = this.check_gamma();
            } else if (0.0 < this.rohat && this.rohat < 0.4) {
                rohatold = this.rohat;
                this.calculate_rohat(1, 2);
                end = this.rohat < rohatold && this.check_gamma();
            } else {
                end = false;
            }
            finalized_iteration = true;
            if (end) {
                this.converge = 1;
                return finalized_iteration;
            }
        }
        if (this.samples[0] == this.Max_samples[0]) {
            ++this.iter;
            this.calculate_rohat(0, 1);
            this.Max_samples[0] = this.Max_samples[0] * 2L;
            this.size_batch[0] = this.Max_samples[0] / 400L;
            this.calculate_averages(0);
            this.batch[0] = this.batch[0] / 2;
            this.averages[0][this.batch[0]] = 0.0;
            if (this.rohat <= 0.0) {
                end = this.check_gamma();
            } else if (0.0 < this.rohat && this.rohat < 0.4) {
                rohatold = this.rohat;
                this.calculate_rohat(0, 2);
                end = this.rohat < rohatold && this.check_gamma();
            } else {
                end = false;
            }
            finalized_iteration = true;
            if (end) {
                this.converge = 1;
                return finalized_iteration;
            }
        }
        return finalized_iteration;
    }

    void calculate_averages(int iteration) {
        int k = 0;
        int i = 0;
        while (i < 200) {
            this.averages[iteration][i] = this.averages[iteration][k] + this.averages[iteration][k + 1];
            double[] dArray = this.averages[iteration];
            int n = i++;
            dArray[n] = dArray[n] / 2.0;
            k += 2;
        }
    }

    int calculate_rohat(int iteration, int which_part) {
        int number_batches = 400 / which_part;
        this.rohat = -0.5 * (this.calculate_ro(iteration, number_batches, 1) + this.calculate_ro(iteration, number_batches, 2)) + 2.0 * this.calculate_ro(iteration, number_batches, 0);
        return 1;
    }

    double calculate_ro(int iteration, int number_batches, int indicator) {
        int from = 0;
        int to = number_batches;
        double numerator = 0.0;
        double denominator = 0.0;
        double old = 0.0;
        double aux = 0.0;
        switch (indicator) {
            case 1: {
                to >>= 1;
                break;
            }
            case 2: {
                from = number_batches >> 1;
            }
        }
        this.average_from_to(iteration, from, to);
        denominator = old = this.averages[iteration][from] - this.total_average;
        denominator *= denominator;
        for (int i = from + 1; i <= to - 1; ++i) {
            aux = this.averages[iteration][i] - this.total_average;
            numerator += old * aux;
            denominator += aux * aux;
            old = aux;
        }
        this.numerator_sy2 = denominator;
        if ((int)denominator == 0) {
            return 0.0;
        }
        return numerator /= denominator;
    }

    void average_from_to(int iteration, int from, int to) {
        int i = 0;
        this.total_average = 0.0;
        for (i = from; i < to; ++i) {
            this.total_average += this.averages[iteration][i];
        }
        this.total_average /= (double)(to - from);
    }

    public boolean check_gamma() {
        double delta = 1.96 * Math.sqrt(this.numerator_sy2 / 159600.0);
        if (this.total_average == 0.0) {
            return false;
        }
        return !((delta /= Math.abs(this.total_average)) > 0.075);
    }

    public String result() {
        String ret = this.total_average + "+-" + 1.96 * Math.sqrt(this.numerator_sy2 / 159600.0 / 1000.0);
        return ret;
    }

    public int getConverge() {
        return this.converge;
    }
}

