/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects.subtlvs;

import es.tid.rsvp.objects.subobjects.subtlvs.SubTLV;

public class SubTransponderTLVModFormat
extends SubTLV {
    private int standardizedFormat;
    private int input;
    private int modulationID;
    private long symbolRate;
    private int numCarriers;
    private int bitSymbol;

    public SubTransponderTLVModFormat() {
        this.setTLVType(5001);
    }

    public SubTransponderTLVModFormat(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTotalTLVLength(16);
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.standardizedFormat << 7 | this.input << 6 | this.modulationID >>> 8);
        this.tlv_bytes[++offset] = (byte)(this.modulationID & 0xFF);
        this.tlv_bytes[offset += 3] = (byte)(this.symbolRate >> 24 & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.symbolRate >> 16 & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.symbolRate >> 8 & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.symbolRate & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.numCarriers >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.numCarriers & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.bitSymbol >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.bitSymbol & 0xFF);
    }

    @Override
    protected void decode() {
        int offset = 4;
        this.standardizedFormat = (this.tlv_bytes[offset] & 0x80) >>> 7;
        this.input = (this.tlv_bytes[offset] & 0x1E) >>> 6;
        this.modulationID = (this.tlv_bytes[offset] & 1) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        offset += 2;
        this.symbolRate = 0L;
        for (int k = 0; k < 4; ++k) {
            this.symbolRate = this.symbolRate << 8 | (long)this.tlv_bytes[k + offset] & 0xFFL;
        }
        this.numCarriers = (this.tlv_bytes[offset += 4] & 0xFF) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        this.bitSymbol = (this.tlv_bytes[offset + 2] & 0xFF) << 8 | this.tlv_bytes[offset + 3] & 0xFF;
    }

    public String toString() {
        String str = "[MF SF: " + this.standardizedFormat + " I: " + this.input + "ModID: " + this.modulationID + "SR: " + this.symbolRate + "NC: " + this.numCarriers + "b/S: " + this.bitSymbol;
        str = str + ">";
        return str;
    }

    public int getstandardizedFormat() {
        return this.standardizedFormat;
    }

    public void setstandardizedFormat(int standardizedFormat) {
        this.standardizedFormat = standardizedFormat;
    }

    public int getInput() {
        return this.input;
    }

    public void setInput(int input) {
        this.input = input;
    }

    public int getModulationID() {
        return this.modulationID;
    }

    public void setModulationID(int modulationID) {
        this.modulationID = modulationID;
    }

    public long getSymbolRate() {
        return this.symbolRate;
    }

    public void setSymbolRate(long symbolRate) {
        this.symbolRate = symbolRate;
    }

    public int getNumCarriers() {
        return this.numCarriers;
    }

    public void setNumCarriers(int numCarriers) {
        this.numCarriers = numCarriers;
    }

    public int getBitSymbol() {
        return this.bitSymbol;
    }

    public void setBitSymbol(int bitSymbol) {
        this.bitSymbol = bitSymbol;
    }
}

