/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects.subtlvs;

import es.tid.rsvp.objects.subobjects.subtlvs.SubTLV;

public class SubTransponderTLVFEC
extends SubTLV {
    private int standardizedFormat;
    private int input;
    private int FEC_id;

    public SubTransponderTLVFEC() {
        this.setTLVType(5002);
    }

    public SubTransponderTLVFEC(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTotalTLVLength(8);
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.standardizedFormat << 7 | this.input << 6 | this.FEC_id >>> 8);
        this.tlv_bytes[++offset] = (byte)(this.FEC_id & 0xFF);
    }

    @Override
    protected void decode() {
        int offset = 4;
        this.standardizedFormat = (this.tlv_bytes[offset] & 0xE0) >>> 7;
        this.input = (this.tlv_bytes[offset] & 0x1E) >>> 6;
        this.FEC_id = (this.tlv_bytes[offset] & 1) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        log.info("Standardized Format : " + this.standardizedFormat + ".");
        log.info("Input : " + this.input + ".");
        log.info("FEC ID : " + this.FEC_id + ".");
    }

    public String toString() {
        String str = "[STFEC  SF: " + this.standardizedFormat + "I: " + this.input + "FEC ID: " + this.FEC_id;
        str = str + "]";
        return str;
    }

    public int getStandardizedFormat() {
        return this.standardizedFormat;
    }

    public void setStandardizedFormat(int standardizedFormat) {
        this.standardizedFormat = standardizedFormat;
    }

    public int getInput() {
        return this.input;
    }

    public void setInput(int input) {
        this.input = input;
    }

    public int getFEC_id() {
        return this.FEC_id;
    }

    public void setFEC_id(int fEC_id) {
        this.FEC_id = fEC_id;
    }
}

