/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.of.DataPathID;
import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.subobjects.EROSubobject;

public class UnnumberedDataPathIDEROSubobject
extends EROSubobject {
    public DataPathID dataPath;
    public long interfaceID;

    public long getInterfaceID() {
        return this.interfaceID;
    }

    public void setInterfaceID(long interfaceID) {
        this.interfaceID = interfaceID;
    }

    public UnnumberedDataPathIDEROSubobject() {
        this.erosolength = 16;
        this.setType(59);
    }

    public UnnumberedDataPathIDEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        int offset = 2;
        System.arraycopy(ByteHandler.MACFormatStringtoByteArray(this.dataPath.getDataPathID()), 0, this.subobject_bytes, offset, 8);
        this.subobject_bytes[offset += 8] = (byte)(this.interfaceID >>> 24);
        this.subobject_bytes[offset + 1] = (byte)(this.interfaceID >>> 16 & 0xFFL);
        this.subobject_bytes[offset + 2] = (byte)(this.interfaceID >>> 8 & 0xFFL);
        this.subobject_bytes[offset + 3] = (byte)(this.interfaceID & 0xFFL);
    }

    @Override
    public void decode() {
        this.decodeSoHeader();
        int offset = 2;
        byte[] bytearray = new byte[8];
        System.arraycopy(this.subobject_bytes, offset, bytearray, 0, 8);
        this.dataPath = DataPathID.getByNameBytes(bytearray);
        this.dataPath.setDataPathID(this.dataPath.getDataPathID().toUpperCase());
        offset += 8;
        this.interfaceID = 0L;
        for (int k = 0; k < 4; ++k) {
            this.interfaceID = this.interfaceID << 8 | (long)(this.subobject_bytes[k + offset] & 0xFF);
        }
    }

    public DataPathID getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(DataPathID dataPath) {
        this.dataPath = dataPath;
    }

    public String toString() {
        return this.dataPath.toString() + "::" + this.interfaceID;
    }
}

