/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import java.util.Arrays;

public abstract class RROSubobject {
    protected int type;
    protected int rrosolength;
    protected byte[] subobject_bytes;

    public abstract void encode();

    public abstract void decode();

    public RROSubobject() {
    }

    public RROSubobject(byte[] bytes, int offset) {
        this.rrosolength = bytes[offset + 1];
        this.subobject_bytes = new byte[this.rrosolength];
        System.arraycopy(bytes, offset, this.subobject_bytes, 0, this.rrosolength);
        this.decodeSoHeader();
    }

    public void encodeSoHeader() {
        this.subobject_bytes[0] = (byte)this.type;
        this.subobject_bytes[1] = (byte)this.rrosolength;
    }

    public void decodeSoHeader() {
        this.type = this.subobject_bytes[0];
        this.rrosolength = this.subobject_bytes[1];
    }

    public static int getLength(byte[] bytes, int offset) {
        byte len = bytes[offset + 1];
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = bytes[offset] & 0x7F;
        return typ;
    }

    public int getRrosolength() {
        return this.rrosolength;
    }

    public void setRrosolength(int rrosolength) {
        this.rrosolength = rrosolength;
    }

    public byte[] getSubobject_bytes() {
        return this.subobject_bytes;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rrosolength;
        result = 31 * result + Arrays.hashCode(this.subobject_bytes);
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RROSubobject other = (RROSubobject)obj;
        if (this.rrosolength != other.rrosolength) {
            return false;
        }
        if (!Arrays.equals(this.subobject_bytes, other.subobject_bytes)) {
            return false;
        }
        return this.type == other.type;
    }
}

