/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.subobjects.EROSubobject;

public class OpenFlowUnnumberIfIDEROSubobject
extends EROSubobject {
    private String switchID;
    public long interfaceID;

    public OpenFlowUnnumberIfIDEROSubobject() {
        this.setType(92);
    }

    public OpenFlowUnnumberIfIDEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.erosolength = 16;
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        this.subobject_bytes[2] = 0;
        this.subobject_bytes[3] = 0;
        System.arraycopy(ByteHandler.MACFormatStringtoByteArray(this.switchID), 0, this.subobject_bytes, 4, 8);
        int offset = 12;
        this.subobject_bytes[offset] = (byte)(this.interfaceID >>> 24);
        this.subobject_bytes[offset + 1] = (byte)(this.interfaceID >>> 16 & 0xFFL);
        this.subobject_bytes[offset + 2] = (byte)(this.interfaceID >>> 8 & 0xFFL);
        this.subobject_bytes[offset + 3] = (byte)(this.interfaceID & 0xFFL);
    }

    @Override
    public void decode() {
        this.decodeSoHeader();
        byte[] mac = new byte[8];
        System.arraycopy(this.subobject_bytes, 4, mac, 0, 8);
        this.switchID = ByteHandler.ByteMACToString(mac);
        int offset = 12;
        this.interfaceID = 0L;
        for (int k = 0; k < 4; ++k) {
            this.interfaceID = this.interfaceID << 8 | (long)(this.subobject_bytes[k + offset] & 0xFF);
        }
    }

    public String getSwitchID() {
        return this.switchID;
    }

    public void setSwitchID(String switchID) {
        this.switchID = switchID;
    }

    public long getInterfaceID() {
        return this.interfaceID;
    }

    public void setInterfaceID(long interfaceID) {
        this.interfaceID = interfaceID;
    }

    public String toString() {
        return this.switchID + "/" + this.interfaceID;
    }
}

