/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.LabelEROSubobject;

public class GeneralizedLabelEROSubobject
extends LabelEROSubobject {
    byte[] label;
    DWDMWavelengthLabel dwdmWavelengthLabel;

    public GeneralizedLabelEROSubobject() {
        this.setCtype(2);
    }

    public GeneralizedLabelEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        if (this.dwdmWavelengthLabel != null) {
            try {
                this.dwdmWavelengthLabel.encode();
            }
            catch (RSVPProtocolViolationException e) {
                e.printStackTrace();
            }
            this.label = new byte[this.dwdmWavelengthLabel.getLength()];
            System.arraycopy(this.dwdmWavelengthLabel.getBytes(), 0, this.label, 0, this.label.length);
        }
        this.setErosolength(4 + this.label.length);
        this.subobject_bytes = new byte[this.erosolength];
        this.setCtype(2);
        this.encodeLabelHeader();
        this.encodeSoHeader();
        System.arraycopy(this.label, 0, this.subobject_bytes, 4, this.label.length);
    }

    @Override
    public void decode() {
        int labelLength = this.getErosolength() - 4;
        if (labelLength == 4 || labelLength == 8) {
            this.dwdmWavelengthLabel = new DWDMWavelengthLabel();
            try {
                this.dwdmWavelengthLabel.decode(this.getSubobject_bytes(), 4);
            }
            catch (RSVPProtocolViolationException e) {
                e.printStackTrace();
            }
        }
        this.label = new byte[labelLength];
        System.arraycopy(this.getSubobject_bytes(), 4, this.label, 0, labelLength);
    }

    public DWDMWavelengthLabel getDwdmWavelengthLabel() {
        return this.dwdmWavelengthLabel;
    }

    public void setDwdmWavelengthLabel(DWDMWavelengthLabel dwdmWavelengthLabel) {
        this.dwdmWavelengthLabel = dwdmWavelengthLabel;
    }

    public byte[] getLabel() {
        return this.label;
    }

    public void setLabel(byte[] label) {
        this.label = label;
    }

    public String toString() {
        String resp = "/ELC: ";
        if (this.dwdmWavelengthLabel != null) {
            resp = resp + this.dwdmWavelengthLabel.toString();
        } else {
            for (int i = 0; i < this.label.length; ++i) {
                resp = resp + Integer.toHexString(this.label[i] & 0xFF);
            }
        }
        return resp;
    }
}

