/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.objects.subobjects.DataPathIDEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberedDataPathIDEROSubobject;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class EROSubobject {
    private Logger log = Logger.getLogger("EROSubobject");
    protected int type;
    protected int erosolength;
    protected boolean loosehop;
    protected byte[] subobject_bytes;

    public EROSubobject() {
    }

    public EROSubobject(byte[] bytes, int offset) {
        this.erosolength = bytes[offset + 1];
        this.subobject_bytes = new byte[this.erosolength];
        System.arraycopy(bytes, offset, this.subobject_bytes, 0, this.erosolength);
        this.decodeSoHeader();
    }

    public abstract void encode();

    public abstract void decode();

    public void encodeSoHeader() {
        this.subobject_bytes[0] = this.loosehop ? (byte)(0x80 | this.type & 0x7F) : (byte)(this.type & 0x7F);
        this.subobject_bytes[1] = (byte)this.erosolength;
    }

    public void decodeSoHeader() {
        int lhopbit = this.subobject_bytes[0] >> 7 & 1;
        this.loosehop = lhopbit == 1;
        this.type = this.subobject_bytes[0] & 0x7F;
        this.erosolength = this.subobject_bytes[1];
    }

    public static int getLength(byte[] bytes, int offset) {
        byte len = bytes[offset + 1];
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = bytes[offset] & 0x7F;
        return typ;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getErosolength() {
        return this.erosolength;
    }

    public void setErosolength(int erosolength) {
        this.erosolength = erosolength;
    }

    public boolean isLoosehop() {
        return this.loosehop;
    }

    public void setLoosehop(boolean loosehop) {
        this.loosehop = loosehop;
    }

    public byte[] getSubobject_bytes() {
        return this.subobject_bytes;
    }

    public void setSubobject_bytes(byte[] subobject_bytes) {
        this.subobject_bytes = subobject_bytes;
    }

    public String getstringNodeEROSubobject(EROSubobject eroSubobject) {
        String stringEROSubobject = null;
        if (eroSubobject instanceof IPv4prefixEROSubobject) {
            stringEROSubobject = ((IPv4prefixEROSubobject)eroSubobject).getIpv4address().getHostAddress();
        } else if (eroSubobject instanceof UnnumberIfIDEROSubobject) {
            stringEROSubobject = ((UnnumberIfIDEROSubobject)eroSubobject).getRouterID().getHostAddress();
        } else if (eroSubobject instanceof DataPathIDEROSubobject) {
            stringEROSubobject = ((DataPathIDEROSubobject)eroSubobject).getDataPath().getDataPathID();
        } else if (eroSubobject instanceof UnnumberedDataPathIDEROSubobject) {
            stringEROSubobject = ((UnnumberedDataPathIDEROSubobject)eroSubobject).getDataPath().getDataPathID();
        } else {
            this.log.info("EROSubobject not implemented in getstringEROSubobject");
        }
        return stringEROSubobject;
    }

    public int getIntfEROSubobject(EROSubobject eroSubobject) {
        int intfEROSubobject = -1;
        if (eroSubobject instanceof UnnumberIfIDEROSubobject) {
            intfEROSubobject = (int)((UnnumberIfIDEROSubobject)eroSubobject).getInterfaceID();
        } else if (eroSubobject instanceof UnnumberedDataPathIDEROSubobject) {
            intfEROSubobject = (int)((UnnumberedDataPathIDEROSubobject)eroSubobject).getInterfaceID();
        } else {
            this.log.info("EROSubobject not implemented in getIntfEROSubobject");
        }
        return intfEROSubobject;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.erosolength;
        result = 31 * result + (this.loosehop ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.subobject_bytes);
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EROSubobject other = (EROSubobject)obj;
        if (this.erosolength != other.erosolength) {
            return false;
        }
        if (this.loosehop != other.loosehop) {
            return false;
        }
        if (!Arrays.equals(this.subobject_bytes, other.subobject_bytes)) {
            return false;
        }
        return this.type == other.type;
    }
}

