/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.gmpls;

import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.gmpls.IfIdTLV;
import java.util.LinkedList;

public class RSVPHopIPv4GMPLS
extends RSVPHopIPv4 {
    private LinkedList<IfIdTLV> tlvs;

    public RSVPHopIPv4GMPLS() {
        this.length = 12;
        this.cType = 3;
        this.tlvs = new LinkedList();
    }

    public void addTLV(IfIdTLV tlv) {
        this.tlvs.add(tlv);
        this.length += tlv.getLength();
    }

    public LinkedList<IfIdTLV> getTlvs() {
        return this.tlvs;
    }

    public void setTlvs(LinkedList<IfIdTLV> tlvs) {
        this.tlvs = tlvs;
    }

    @Override
    public void encode() {
        this.length = 12;
        int tlvsNumber = this.tlvs.size();
        for (int i = 0; i < tlvsNumber; ++i) {
            IfIdTLV ifId = this.tlvs.get(i);
            this.length += ifId.getLength();
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.next_previousHopAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        int offset = 8;
        this.bytes[offset] = (byte)((this.logicalInterfaceHandle & 0xFF000000L) >> 24);
        this.bytes[offset + 1] = (byte)((this.logicalInterfaceHandle & 0xFF0000L) >> 16);
        this.bytes[offset + 2] = (byte)((this.logicalInterfaceHandle & 0xFF00L) >> 8);
        this.bytes[offset + 3] = (byte)(this.logicalInterfaceHandle & 0xFFL);
        int currentIndex = 12;
        for (int j = 0; j < tlvsNumber; ++j) {
            IfIdTLV ifId = this.tlvs.get(j);
            ifId.encode();
            System.arraycopy(ifId.getBytes(), 0, this.bytes, currentIndex, ifId.getLength());
            currentIndex += ifId.getLength();
        }
    }
}

