/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPObject;

public class TimeValues
extends RSVPObject {
    protected long refreshPeriod;

    public TimeValues() {
        this.classNum = 5;
        this.cType = 1;
        this.length = 8;
    }

    public TimeValues(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public TimeValues(long refreshPeriod) {
        this.classNum = 5;
        this.cType = 1;
        this.length = 8;
        this.refreshPeriod = refreshPeriod;
    }

    @Override
    public void encode() {
        this.bytes = new byte[this.length];
        this.refreshPeriod = 0L;
        this.encodeHeader();
        this.bytes[4] = (byte)(this.refreshPeriod >> 24 & 0xFFL);
        this.bytes[5] = (byte)(this.refreshPeriod >> 16 & 0xFFL);
        this.bytes[6] = (byte)(this.refreshPeriod >> 8 & 0xFFL);
        this.bytes[7] = (byte)(this.refreshPeriod & 0xFFL);
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(long refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    public void decode() {
        int offset = 4;
        this.refreshPeriod = ByteHandler.decode4bytesLong(this.getBytes(), offset);
    }
}

