/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPObject;

public class Style
extends RSVPObject {
    protected int flags;
    protected int optionVector;

    public Style() {
        this.classNum = 8;
        this.cType = 1;
        this.flags = 0;
        this.optionVector = 0;
    }

    public Style(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public Style(int flags, int optionVector) {
        this.classNum = 8;
        this.cType = 1;
        this.flags = flags;
        this.optionVector = optionVector;
    }

    @Override
    public void encode() {
        this.length = 8;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        this.bytes[4] = (byte)(this.flags & 0xFF);
        this.bytes[5] = (byte)(this.optionVector >> 16 & 0xFF);
        this.bytes[6] = (byte)(this.optionVector >> 8 & 0xFF);
        this.bytes[7] = (byte)(this.optionVector & 0xFF);
    }

    public void decode() {
        int offset = 0;
        this.optionVector = 0;
        this.flags = this.bytes[4] & 0xFF;
        for (int k = 5; k < 8; ++k) {
            this.optionVector = this.optionVector << 8 | this.bytes[offset + k] & 0xFF;
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getOptionVector() {
        return this.optionVector;
    }

    public void setOptionVector(int optionVector) {
        this.optionVector = optionVector;
    }
}

