/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Session;
import java.net.Inet4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLSPTunnelIPv4
extends Session {
    protected Inet4Address egressNodeAddress;
    protected long tunnelId;
    protected Inet4Address extendedTunnelId;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public SessionLSPTunnelIPv4() {
        this.classNum = 1;
        this.cType = 7;
    }

    public SessionLSPTunnelIPv4(Inet4Address egressNodeAddress, long tunnelId, Inet4Address extendedTunnelId) {
        this.classNum = 1;
        this.cType = 7;
        this.egressNodeAddress = egressNodeAddress;
        this.tunnelId = tunnelId;
        this.extendedTunnelId = extendedTunnelId;
        log.debug("Session LSP Tunnel IPv4 Object Created");
    }

    public SessionLSPTunnelIPv4(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
        log.debug("Session LSP Tunnel IPv4 Object Created");
    }

    @Override
    public void encode() {
        this.length = 16;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.egressNodeAddress.getAddress();
        int currentIndex = 4;
        System.arraycopy(addr, 0, this.getBytes(), currentIndex, addr.length);
        this.bytes[currentIndex += addr.length] = 0;
        this.bytes[currentIndex + 1] = 0;
        this.bytes[currentIndex + 2] = (byte)(this.tunnelId >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.tunnelId & 0xFFL);
        addr = this.extendedTunnelId.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), currentIndex += 4, addr.length);
    }

    public void decode() throws RSVPProtocolViolationException {
        try {
            int offset = 4;
            byte[] receivedAddress = new byte[4];
            System.arraycopy(this.bytes, offset, receivedAddress, 0, 4);
            this.egressNodeAddress = (Inet4Address)Inet4Address.getByAddress(receivedAddress);
            this.tunnelId = this.bytes[(offset += 4) + 2] & 0xFF00 | this.bytes[offset + 3];
            byte[] identTun = new byte[4];
            System.arraycopy(this.bytes, offset += 4, identTun, 0, 4);
            this.extendedTunnelId = (Inet4Address)Inet4Address.getByAddress(identTun);
        }
        catch (Exception e) {
            throw new RSVPProtocolViolationException();
        }
    }

    public Inet4Address getEgressNodeAddress() {
        return this.egressNodeAddress;
    }

    public void setEgressNodeAddress(Inet4Address egressNodeAddress) {
        this.egressNodeAddress = egressNodeAddress;
    }

    public long getTunnelId() {
        return this.tunnelId;
    }

    public void setTunnelId(long tunnelId) {
        this.tunnelId = tunnelId;
    }

    public Inet4Address getExtendedTunnelId() {
        return this.extendedTunnelId;
    }

    public void setExtendedTunnelId(Inet4Address extendedTunnelId) {
        this.extendedTunnelId = extendedTunnelId;
    }
}

