/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Session;
import java.net.Inet6Address;

public class SessionIPv6
extends Session {
    protected Inet6Address destAddress;
    protected int protocolId;
    protected int flags;
    protected int destPort;

    public SessionIPv6() {
        this.classNum = 1;
        this.cType = 2;
        this.protocolId = 0;
        this.flags = 0;
        this.destPort = 0;
    }

    public SessionIPv6(Inet6Address destAddress, int protocolId, int flags, int destPort) {
        this.destAddress = destAddress;
        this.protocolId = protocolId;
        this.flags = flags;
        this.destPort = destPort;
    }

    public SessionIPv6(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.length = 24;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int offset = 4;
        if (this.destAddress != null) {
            byte[] addr = this.destAddress.getAddress();
            System.arraycopy(this.getBytes(), 4, addr, 0, addr.length);
        } else {
            this.bytes[offset] = 0;
            this.bytes[offset + 1] = 0;
            this.bytes[offset + 2] = 0;
            this.bytes[offset + 3] = 0;
            this.bytes[offset + 4] = 0;
            this.bytes[offset + 5] = 0;
            this.bytes[offset + 6] = 0;
            this.bytes[offset + 7] = 0;
            this.bytes[offset + 8] = 0;
            this.bytes[offset + 9] = 0;
            this.bytes[offset + 10] = 0;
            this.bytes[offset + 11] = 0;
            this.bytes[offset + 12] = 0;
            this.bytes[offset + 13] = 0;
            this.bytes[offset + 14] = 0;
            this.bytes[offset + 15] = 0;
        }
        this.bytes[offset += 16] = (byte)this.protocolId;
        this.bytes[offset + 1] = (byte)this.flags;
        this.bytes[offset + 2] = (byte)(this.destPort >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(this.destPort & 0xFF);
    }

    public void decode() throws RSVPProtocolViolationException {
        try {
            byte[] receivedAddress = new byte[16];
            int offset = 4;
            System.arraycopy(this.bytes, offset, receivedAddress, 0, 16);
            this.destAddress = (Inet6Address)Inet6Address.getByAddress(receivedAddress);
            this.protocolId = this.bytes[offset += 16];
            this.flags = this.bytes[offset + 1] & 0xFF;
            this.destPort = ByteHandler.decode2bytesInteger(this.bytes, offset + 2);
        }
        catch (Exception e) {
            throw new RSVPProtocolViolationException();
        }
    }

    public Inet6Address getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(Inet6Address destAddress) {
        this.destAddress = destAddress;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        this.destPort = destPort;
    }
}

