/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Session;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class SessionIPv4
extends Session {
    protected Inet4Address destAddress;
    protected int protocolId;
    protected int flags;
    protected int destPort;

    public SessionIPv4() {
        this.classNum = 1;
        this.cType = 1;
        this.protocolId = 0;
        this.flags = 0;
        this.destPort = 0;
    }

    public SessionIPv4(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public SessionIPv4(Inet4Address destAddress, int protocolId, int flags, int destPort) {
        this.classNum = 1;
        this.cType = 1;
        this.destAddress = destAddress;
        this.protocolId = protocolId;
        this.flags = flags;
        this.destPort = destPort;
    }

    @Override
    public void encode() {
        this.length = 12;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.destAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[8] = (byte)this.protocolId;
        this.bytes[9] = (byte)this.flags;
        this.bytes[10] = (byte)(this.destPort >> 8 & 0xFF);
        this.bytes[11] = (byte)(this.destPort & 0xFF);
    }

    public void decode() {
        int offset = 0;
        byte[] receivedAddress = new byte[4];
        System.arraycopy(this.bytes, offset + 4, receivedAddress, 0, 4);
        try {
            this.destAddress = (Inet4Address)Inet4Address.getByAddress(receivedAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.protocolId = this.bytes[offset + 8] & 0xFF;
        this.flags = this.bytes[offset + 9] & 0xFF;
        this.destPort = ByteHandler.decode2bytesInteger(this.bytes, offset + 10);
    }

    public Inet4Address getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(Inet4Address destAddress) {
        this.destAddress = destAddress;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        this.destPort = destPort;
    }
}

