/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.objects.SenderTemplate;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderTemplateLSPTunnelIPv6
extends SenderTemplate {
    private Inet6Address senderNodeAddress;
    private int LSPId;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public SenderTemplateLSPTunnelIPv6() {
        this.cType = 8;
    }

    public SenderTemplateLSPTunnelIPv6(Inet6Address senderNodeAddress, int LSPId) {
        this.classNum = 11;
        this.cType = 8;
        this.senderNodeAddress = senderNodeAddress;
        this.LSPId = LSPId;
        log.debug("Sender Template LSP Tunnel IPv6 Object Created");
    }

    public SenderTemplateLSPTunnelIPv6(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
        log.debug("Sender Template LSP Tunnel IPv6 Object Created");
    }

    @Override
    public void encode() {
        this.length = 24;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.senderNodeAddress.getAddress();
        int currentIndex = 4;
        System.arraycopy(addr, 0, this.getBytes(), currentIndex, addr.length);
        this.bytes[currentIndex += addr.length] = 0;
        this.bytes[currentIndex + 1] = 0;
        this.bytes[currentIndex + 2] = (byte)(this.LSPId >> 8 & 0xFF);
        this.bytes[currentIndex + 3] = (byte)(this.LSPId & 0xFF);
        log.debug("Sender Template LSP Tunnel IPv6 Object Encoded");
    }

    @Override
    public void decode() {
        int offset = 0;
        byte[] receivedAddress = new byte[16];
        System.arraycopy(this.bytes, offset += 4, receivedAddress, 0, 16);
        try {
            this.senderNodeAddress = (Inet6Address)Inet6Address.getByAddress(receivedAddress);
        }
        catch (UnknownHostException e) {
            log.error("Unknown Host received on Sender Template LSP IPv6 Object");
        }
        this.LSPId = this.bytes[(offset += receivedAddress.length) + 2] | this.bytes[offset + 3];
        log.debug("Sender Template LSP Tunnel IPv6 Object Decoded");
    }

    public Inet6Address getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public void setSenderNodeAddress(Inet6Address senderNodeAddress) {
        this.senderNodeAddress = senderNodeAddress;
    }

    public int getLSPId() {
        return this.LSPId;
    }

    public void setLSPId(int lSPId) {
        this.LSPId = lSPId;
    }
}

