/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.objects.ResvConfirm;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class ResvConfirmIPv6
extends ResvConfirm {
    protected Inet6Address receiverAddress;

    public ResvConfirmIPv6() {
        this.classNum = 15;
        this.cType = 2;
        this.length = 20;
        this.bytes = new byte[this.length];
    }

    public ResvConfirmIPv6(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    public ResvConfirmIPv6(Inet6Address receiverAddress) {
        this.classNum = 15;
        this.cType = 2;
        this.receiverAddress = receiverAddress;
    }

    @Override
    public void encode() {
        this.length = 20;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        if (this.receiverAddress != null) {
            byte[] addr = this.receiverAddress.getAddress();
            System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        } else {
            this.bytes[4] = 0;
            this.bytes[5] = 0;
            this.bytes[6] = 0;
            this.bytes[7] = 0;
        }
    }

    @Override
    public void decode() {
        int offset = 0;
        byte[] receivedAddress = new byte[16];
        System.arraycopy(this.bytes, offset + 4, receivedAddress, 0, 16);
        try {
            this.receiverAddress = (Inet6Address)Inet6Address.getByAddress(receivedAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public Inet6Address getReceiverAddress() {
        return this.receiverAddress;
    }

    public void setReceiverAddress(Inet6Address receiverAddress) {
        this.receiverAddress = receiverAddress;
    }
}

