/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPElement;
import es.tid.rsvp.RSVPProtocolViolationException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RSVPObject
implements RSVPElement {
    protected int length;
    protected int classNum;
    protected int cType;
    protected byte[] bytes;
    private static final Logger log = LoggerFactory.getLogger("RSVPParser");

    public RSVPObject(byte[] bytes, int offset) {
        this.length = bytes[offset] << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
        this.classNum = bytes[offset + 2] & 0xFF;
        this.cType = bytes[offset + 3];
    }

    public RSVPObject() {
    }

    public void encodeHeader() {
        this.bytes[0] = (byte)(this.length >> 8 & 0xFF);
        this.bytes[1] = (byte)(this.length & 0xFF);
        this.bytes[2] = (byte)this.classNum;
        this.bytes[3] = (byte)this.cType;
    }

    public void decodeHeader(byte[] bytes, int offset) {
        this.length = bytes[offset] << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        this.classNum = bytes[offset + 2] & 0xFF;
        this.cType = bytes[offset + 3];
    }

    @Override
    public abstract void encode() throws RSVPProtocolViolationException;

    @Override
    public int getLength() {
        return this.length;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public int getClassNum() {
        return this.classNum;
    }

    public void setClassNum(int classNum) {
        this.classNum = classNum;
    }

    public int getcType() {
        return this.cType;
    }

    public void setcType(int cType) {
        this.cType = cType;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public static int getClassNum(byte[] bytes, int offset) {
        return bytes[offset + 2] & 0xFF;
    }

    public static int getcType(byte[] bytes, int offset) {
        return bytes[offset + 3] & 0xFF;
    }

    public static int getLength(byte[] bytes, int offset) {
        return bytes[offset] << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.cType;
        result = 31 * result + this.classNum;
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSVPObject other = (RSVPObject)obj;
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        if (this.cType != other.cType) {
            return false;
        }
        if (this.classNum != other.classNum) {
            return false;
        }
        return this.length == other.length;
    }
}

