/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPHop;
import java.net.Inet4Address;

public class RSVPHopIPv4
extends RSVPHop {
    protected Inet4Address next_previousHopAddress;
    protected long logicalInterfaceHandle;

    public RSVPHopIPv4() {
        this.classNum = 3;
        this.cType = 1;
        this.logicalInterfaceHandle = 0L;
    }

    public RSVPHopIPv4(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public RSVPHopIPv4(Inet4Address next_previousHopAddress, int logicalInterfaceHandle) {
        this.classNum = 3;
        this.cType = 1;
        this.next_previousHopAddress = next_previousHopAddress;
        this.logicalInterfaceHandle = logicalInterfaceHandle;
    }

    @Override
    public void encode() {
        this.length = 12;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.next_previousHopAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        int offset = 8;
        this.bytes[offset] = (byte)((this.logicalInterfaceHandle & 0xFF000000L) >> 24);
        this.bytes[offset + 1] = (byte)((this.logicalInterfaceHandle & 0xFF0000L) >> 16);
        this.bytes[offset + 2] = (byte)((this.logicalInterfaceHandle & 0xFF00L) >> 8);
        this.bytes[offset + 3] = (byte)(this.logicalInterfaceHandle & 0xFFL);
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        try {
            int offset = 0;
            byte[] receivedAddress = new byte[4];
            System.arraycopy(this.bytes, offset + 4, receivedAddress, 0, 4);
            this.next_previousHopAddress = (Inet4Address)Inet4Address.getByAddress(receivedAddress);
            this.logicalInterfaceHandle = ByteHandler.decode4bytesLong(this.bytes, offset + 8);
        }
        catch (Exception e) {
            throw new RSVPProtocolViolationException();
        }
    }

    public Inet4Address getNext_previousHopAddress() {
        return this.next_previousHopAddress;
    }

    public void setNext_previousHopAddress(Inet4Address next_previousHopAddress) {
        this.next_previousHopAddress = next_previousHopAddress;
    }

    public double getLogicalInterfaceHandle() {
        return this.logicalInterfaceHandle;
    }

    public void setLogicalInterfaceHandle(long logicalInterfaceHandle) {
        this.logicalInterfaceHandle = logicalInterfaceHandle;
    }
}

