/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4AddressRROSubobject;
import es.tid.rsvp.objects.subobjects.IPv6AddressRROSubobject;
import es.tid.rsvp.objects.subobjects.LabelRROSubobject;
import es.tid.rsvp.objects.subobjects.RROSubobject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RRO
extends RSVPObject {
    private LinkedList<RROSubobject> rroSubobjects;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public RRO() {
        this.classNum = 21;
        this.cType = 1;
        this.length = 4;
        this.rroSubobjects = new LinkedList();
        log.debug("RRO Object Created");
    }

    public RRO(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
        log.debug("RRO Object Created");
    }

    public void addRROubobject(RROSubobject rroSO) {
        this.rroSubobjects.add(rroSO);
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 4;
        int subObjectsNumber = this.rroSubobjects.size();
        for (int i = 0; i < subObjectsNumber; ++i) {
            RROSubobject rroSO = this.rroSubobjects.get(i);
            this.length += rroSO.getRrosolength();
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        for (int i = 0; i < subObjectsNumber; ++i) {
            RROSubobject rroSO = this.rroSubobjects.get(i);
            rroSO.encode();
            System.arraycopy(rroSO.getSubobject_bytes(), 0, this.bytes, currentIndex, rroSO.getRrosolength());
            currentIndex += rroSO.getRrosolength();
        }
    }

    public void decode() throws RSVPProtocolViolationException {
        int subojectlength;
        this.rroSubobjects = new LinkedList();
        int offset = 4;
        for (int unprocessedBytes = this.getLength() - 4; unprocessedBytes > 0; unprocessedBytes -= subojectlength) {
            int subojectclass = EROSubobject.getType(this.getBytes(), offset);
            subojectlength = EROSubobject.getLength(this.getBytes(), offset);
            switch (subojectclass) {
                case 1: {
                    IPv4AddressRROSubobject sobjt4 = new IPv4AddressRROSubobject(this.getBytes(), offset);
                    this.addRROubobject(sobjt4);
                    break;
                }
                case 2: {
                    IPv6AddressRROSubobject sobjt6 = new IPv6AddressRROSubobject(this.getBytes(), offset);
                    this.addRROubobject(sobjt6);
                    break;
                }
                case 3: {
                    LabelRROSubobject lrroso = new LabelRROSubobject(this.getBytes(), offset);
                    this.addRROubobject(lrroso);
                    break;
                }
                default: {
                    log.warn("RRO Subobject Unknown");
                    throw new RSVPProtocolViolationException();
                }
            }
            offset += subojectlength;
        }
    }

    public LinkedList<RROSubobject> getRroSubobjects() {
        return this.rroSubobjects;
    }

    public void setRroSubobjects(LinkedList<RROSubobject> rro) {
        this.rroSubobjects = rro;
    }
}

