/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.LabelRequest;
import es.tid.rsvp.objects.RSVPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelRequestWOLabelRange
extends LabelRequest {
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public LabelRequestWOLabelRange(int l3PID) {
        this.classNum = 19;
        this.cType = 1;
        this.length = 8;
        this.reserved = 0;
        this.l3PID = l3PID;
        log.debug("Label Request Without Label Range Object Created");
    }

    public LabelRequestWOLabelRange(byte[] bytes, int offset) {
        this.decodeHeader(bytes, offset);
        this.bytes = new byte[RSVPObject.getLength(bytes, offset)];
        log.debug("Label Request Without Label Range Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 4;
        this.length += 4;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        this.bytes[currentIndex] = (byte)(this.reserved >> 8 & 0xFF);
        this.bytes[currentIndex + 1] = (byte)this.reserved;
        this.bytes[currentIndex + 2] = (byte)(this.l3PID >> 8 & 0xFF);
        this.bytes[currentIndex + 3] = (byte)(this.l3PID & 0xFF);
    }

    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("Starting Label Request Without Label Range Object decoding");
        int currentIndex = offset + 4;
        this.l3PID = bytes[currentIndex + 2] | bytes[currentIndex + 3];
        log.debug("Label Request Without Label Range Object decoded");
    }
}

