/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.objects.FilterSpec;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class FlowLabelFilterSpecIPv6
extends FilterSpec {
    protected Inet6Address srcAddress;
    protected int flowLabel;

    public FlowLabelFilterSpecIPv6() {
        this.classNum = 10;
        this.cType = 3;
        this.length = 24;
        this.flowLabel = 0;
    }

    public FlowLabelFilterSpecIPv6(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    public FlowLabelFilterSpecIPv6(Inet6Address srcAddress, int flowLabel) {
        this.classNum = 10;
        this.cType = 3;
        this.srcAddress = srcAddress;
        this.flowLabel = flowLabel;
    }

    @Override
    public void encode() {
        this.length = 24;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.srcAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[21] = (byte)(this.flowLabel >> 16 & 0xFF);
        this.bytes[22] = (byte)(this.flowLabel >> 8 & 0xFF);
        this.bytes[23] = (byte)(this.flowLabel & 0xFF);
    }

    @Override
    public void decode() {
        int offset = 0;
        int currentIndex = offset + 4;
        byte[] readAddress = new byte[16];
        System.arraycopy(this.bytes, currentIndex, readAddress, 0, 16);
        try {
            this.srcAddress = (Inet6Address)Inet6Address.getByAddress(readAddress);
            currentIndex += 16;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.flowLabel = this.bytes[currentIndex + 1] | this.bytes[currentIndex + 2] | this.bytes[currentIndex + 3];
    }

    public Inet6Address getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(Inet6Address srcAddress) {
        this.srcAddress = srcAddress;
    }

    public int getFlowLabel() {
        return this.flowLabel;
    }

    public void setFlowLabel(int flowLabel) {
        this.flowLabel = flowLabel;
    }
}

