/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.FilterSpec;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class FilterSpecIPv6
extends FilterSpec {
    protected Inet6Address srcAddress;
    protected int srcPort;

    public FilterSpecIPv6() {
        this.classNum = 10;
        this.cType = 2;
        this.length = 24;
        this.bytes = new byte[this.length];
        this.srcPort = 0;
    }

    public FilterSpecIPv6(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    public FilterSpecIPv6(Inet6Address srcAddress, int srcPort) {
        this.classNum = 10;
        this.cType = 2;
        this.length = 24;
        this.bytes = new byte[this.length];
        this.srcAddress = srcAddress;
        this.srcPort = srcPort;
    }

    @Override
    public void encode() {
        this.encodeHeader();
        byte[] addr = this.srcAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[22] = (byte)(this.srcPort >> 8 & 0xFF);
        this.bytes[23] = (byte)(this.srcPort & 0xFF);
    }

    @Override
    public void decode() {
        int headerSize;
        int currentIndex = headerSize = 4;
        byte[] readAddress = new byte[16];
        System.arraycopy(this.bytes, currentIndex, readAddress, 0, 16);
        try {
            this.srcAddress = (Inet6Address)Inet6Address.getByAddress(readAddress);
            currentIndex += 16;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.srcPort = ByteHandler.decode2bytesInteger(this.bytes, currentIndex + 2);
    }

    public Inet6Address getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(Inet6Address srcAddress) {
        this.srcAddress = srcAddress;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }
}

