/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.FilterSpec;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class FilterSpecIPv4
extends FilterSpec {
    protected Inet4Address srcAddress;
    protected int srcPort;

    public FilterSpecIPv4() {
        this.classNum = 10;
        this.cType = 1;
        try {
            this.srcAddress = (Inet4Address)Inet4Address.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.srcPort = 0;
    }

    public FilterSpecIPv4(Inet4Address srcAddress, int srcPort) {
        this.classNum = 10;
        this.cType = 1;
        this.srcAddress = srcAddress;
        this.srcPort = srcPort;
    }

    public FilterSpecIPv4(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.length = 12;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.srcAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[10] = (byte)(this.srcPort >> 8 & 0xFF);
        this.bytes[11] = (byte)(this.srcPort & 0xFF);
    }

    @Override
    public void decode() {
        int headerSize;
        int currentIndex = headerSize = 4;
        byte[] readAddress = new byte[4];
        System.arraycopy(this.bytes, currentIndex, readAddress, 0, 4);
        try {
            this.srcAddress = (Inet4Address)Inet4Address.getByAddress(readAddress);
            currentIndex += 4;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.srcPort = ByteHandler.decode2bytesInteger(this.bytes, currentIndex + 2);
    }

    public Inet4Address getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(Inet4Address srcAddress) {
        this.srcAddress = srcAddress;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }
}

